/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.clustering.peerpressure;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticMapReduce;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class ClusterPopulationMapReduce
extends StaticMapReduce<Serializable, Long, Serializable, Long, Map<Serializable, Long>> {
    public static final String CLUSTER_POPULATION_MEMORY_KEY = "gremlin.clusterPopulationMapReduce.memoryKey";
    public static final String DEFAULT_MEMORY_KEY = "clusterPopulation";
    private String memoryKey = "clusterPopulation";

    private ClusterPopulationMapReduce() {
    }

    private ClusterPopulationMapReduce(String memoryKey) {
        this.memoryKey = memoryKey;
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        configuration.setProperty(CLUSTER_POPULATION_MEMORY_KEY, (Object)this.memoryKey);
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        this.memoryKey = configuration.getString(CLUSTER_POPULATION_MEMORY_KEY, DEFAULT_MEMORY_KEY);
    }

    @Override
    public boolean doStage(MapReduce.Stage stage) {
        return true;
    }

    @Override
    public void map(Vertex vertex, MapReduce.MapEmitter<Serializable, Long> emitter) {
        Property cluster = vertex.property("gremlin.peerPressureVertexProgram.cluster");
        if (cluster.isPresent()) {
            emitter.emit((Serializable)cluster.value(), 1L);
        }
    }

    @Override
    public void combine(Serializable key, Iterator<Long> values, MapReduce.ReduceEmitter<Serializable, Long> emitter) {
        this.reduce(key, values, emitter);
    }

    @Override
    public void reduce(Serializable key, Iterator<Long> values, MapReduce.ReduceEmitter<Serializable, Long> emitter) {
        long count = 0L;
        while (values.hasNext()) {
            count += values.next().longValue();
        }
        emitter.emit(key, count);
    }

    @Override
    public Map<Serializable, Long> generateFinalResult(Iterator<KeyValue<Serializable, Long>> keyValues) {
        HashMap<Serializable, Long> clusterPopulation = new HashMap<Serializable, Long>();
        keyValues.forEachRemaining(pair -> {
            Long cfr_ignored_0 = (Long)clusterPopulation.put((Serializable)pair.getKey(), (Long)pair.getValue());
        });
        return clusterPopulation;
    }

    @Override
    public String getMemoryKey() {
        return this.memoryKey;
    }

    @Override
    public String toString() {
        return StringFactory.mapReduceString(this, this.memoryKey);
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private String memoryKey = "clusterPopulation";

        private Builder() {
        }

        public Builder memoryKey(String memoryKey) {
            this.memoryKey = memoryKey;
            return this;
        }

        public ClusterPopulationMapReduce create() {
            return new ClusterPopulationMapReduce(this.memoryKey);
        }
    }
}

