/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyProperty;

public interface Property<V> {
    public String key();

    public V value() throws NoSuchElementException;

    public boolean isPresent();

    default public void ifPresent(Consumer<? super V> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value());
        }
    }

    default public V orElse(V otherValue) {
        return this.isPresent() ? this.value() : otherValue;
    }

    default public V orElseGet(Supplier<? extends V> valueSupplier) {
        return this.isPresent() ? this.value() : valueSupplier.get();
    }

    default public <E extends Throwable> V orElseThrow(Supplier<? extends E> exceptionSupplier) throws E {
        if (this.isPresent()) {
            return this.value();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public Element element();

    public void remove();

    public static <V> Property<V> empty() {
        return EmptyProperty.instance();
    }

    public static class Exceptions {
        private Exceptions() {
        }

        public static IllegalArgumentException propertyKeyCanNotBeEmpty() {
            return new IllegalArgumentException("Property key can not be the empty string");
        }

        public static IllegalArgumentException propertyKeyCanNotBeNull() {
            return new IllegalArgumentException("Property key can not be null");
        }

        public static IllegalArgumentException propertyValueCanNotBeNull() {
            return new IllegalArgumentException("Property value can not be null");
        }

        public static IllegalArgumentException propertyKeyCanNotBeAHiddenKey(String key) {
            return new IllegalArgumentException("Property key can not be a hidden key: " + key);
        }

        public static IllegalStateException propertyDoesNotExist() {
            return new IllegalStateException("The property does not exist as it has no key, value, or associated element");
        }

        public static IllegalStateException propertyDoesNotExist(Element element, String key) {
            return new IllegalStateException("The property does not exist as the key has no associated value for the provided element: " + element + ":" + key);
        }

        public static IllegalArgumentException dataTypeOfPropertyValueNotSupported(Object val) {
            return Exceptions.dataTypeOfPropertyValueNotSupported(val, null);
        }

        public static IllegalArgumentException dataTypeOfPropertyValueNotSupported(Object val, Exception rootCause) {
            return new IllegalArgumentException(String.format("Property value [%s] is of type %s is not supported", val, val.getClass()), rootCause);
        }

        public static IllegalStateException propertyRemovalNotSupported() {
            return new IllegalStateException("Property removal is not supported");
        }
    }
}

