/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.cli.AclParser;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.data.ACL;

public class CreateCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public CreateCommand() {
        super("create", "[-s] [-e] [-c] path [data] [acl]");
        options.addOption(new Option("e", false, "ephemeral"));
        options.addOption(new Option("s", false, "sequential"));
        options.addOption(new Option("c", false, "container"));
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        this.cl = parser.parse(options, cmdArgs);
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new ParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws KeeperException, InterruptedException {
        CreateMode flags = CreateMode.PERSISTENT;
        boolean hasE = this.cl.hasOption("e");
        boolean hasS = this.cl.hasOption("s");
        boolean hasC = this.cl.hasOption("c");
        if (hasC && (hasE || hasS)) {
            this.err.println("-c cannot be combined with -s or -e. Containers cannot be ephemeral or sequential.");
            return false;
        }
        if (hasE && hasS) {
            flags = CreateMode.EPHEMERAL_SEQUENTIAL;
        } else if (hasE) {
            flags = CreateMode.EPHEMERAL;
        } else if (hasS) {
            flags = CreateMode.PERSISTENT_SEQUENTIAL;
        } else if (hasC) {
            flags = CreateMode.CONTAINER;
        }
        String path = this.args[1];
        byte[] data = null;
        if (this.args.length > 2) {
            data = this.args[2].getBytes();
        }
        List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        if (this.args.length > 3) {
            acl = AclParser.parse(this.args[3]);
        }
        try {
            String newPath = this.zk.create(path, data, acl, flags);
            this.err.println("Created " + newPath);
        }
        catch (KeeperException.EphemeralOnLocalSessionException e) {
            this.err.println("Unable to create ephemeral node on a local session");
            return false;
        }
        catch (KeeperException.InvalidACLException ex) {
            this.err.println(ex.getMessage());
            return false;
        }
        return true;
    }
}

