/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.Stat;

public class GetCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetCommand() {
        super("get", "[-s] [-w] path");
        options.addOption("s", false, "stats");
        options.addOption("w", false, "watch");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        this.cl = parser.parse(options, cmdArgs);
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new ParseException(this.getUsageStr());
        }
        this.retainCompatibility(cmdArgs);
        return this;
    }

    private void retainCompatibility(String[] cmdArgs) throws ParseException {
        if (this.args.length > 2) {
            cmdArgs[2] = "-w";
            this.err.println("'get path [watch]' has been deprecated. Please use 'get [-s] [-w] path' instead.");
            PosixParser parser = new PosixParser();
            this.cl = parser.parse(options, cmdArgs);
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws KeeperException, InterruptedException {
        Stat stat;
        String path = this.args[1];
        boolean watch = this.cl.hasOption("w");
        byte[] data = this.zk.getData(path, watch, stat = new Stat());
        data = data == null ? "null".getBytes() : data;
        this.out.println(new String(data));
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return watch;
    }
}

