/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.common.AtomicFileWritingIdiom;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.common.StringUtils;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.VerifyingFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class QuorumPeerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumPeerConfig.class);
    private static final int UNSET_SERVERID = -1;
    public static final String nextDynamicConfigFileSuffix = ".dynamic.next";
    private static boolean standaloneEnabled = true;
    protected InetSocketAddress clientPortAddress;
    protected InetSocketAddress secureClientPortAddress;
    protected File dataDir;
    protected File dataLogDir;
    protected String dynamicConfigFileStr = null;
    protected String configFileStr = null;
    protected int tickTime = 3000;
    protected int maxClientCnxns = 60;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected boolean localSessionsEnabled = false;
    protected boolean localSessionsUpgradingEnabled = false;
    protected int initLimit;
    protected int syncLimit;
    protected int electionAlg = 3;
    protected int electionPort = 2182;
    protected boolean quorumListenOnAllIPs = false;
    protected long serverId = -1L;
    protected QuorumVerifier quorumVerifier = null;
    protected QuorumVerifier lastSeenQuorumVerifier = null;
    protected int snapRetainCount = 3;
    protected int purgeInterval = 0;
    protected boolean syncEnabled = true;
    protected QuorumPeer.LearnerType peerType = QuorumPeer.LearnerType.PARTICIPANT;
    private final int MIN_SNAP_RETAIN_COUNT = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String path) throws ConfigException {
        LOG.info("Reading configuration from: " + path);
        try {
            File configFile = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().create(path);
            Properties cfg = new Properties();
            try (FileInputStream in = new FileInputStream(configFile);){
                cfg.load(in);
                this.configFileStr = path;
            }
            this.parseProperties(cfg);
        }
        catch (IOException e) {
            throw new ConfigException("Error processing " + path, e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Error processing " + path, e);
        }
        if (this.dynamicConfigFileStr != null) {
            try {
                Properties dynamicCfg = new Properties();
                try (FileInputStream inConfig = new FileInputStream(this.dynamicConfigFileStr);){
                    dynamicCfg.load(inConfig);
                    if (dynamicCfg.getProperty("version") != null) {
                        throw new ConfigException("dynamic file shouldn't have version inside");
                    }
                    String version = QuorumPeerConfig.getVersionFromFilename(this.dynamicConfigFileStr);
                    if (version != null) {
                        dynamicCfg.setProperty("version", version);
                    }
                }
                this.setupQuorumPeerConfig(dynamicCfg, false);
            }
            catch (IOException e) {
                throw new ConfigException("Error processing " + this.dynamicConfigFileStr, e);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException("Error processing " + this.dynamicConfigFileStr, e);
            }
            File nextDynamicConfigFile = new File(this.configFileStr + nextDynamicConfigFileSuffix);
            if (nextDynamicConfigFile.exists()) {
                try {
                    Properties dynamicConfigNextCfg = new Properties();
                    try (FileInputStream inConfigNext = new FileInputStream(nextDynamicConfigFile);){
                        dynamicConfigNextCfg.load(inConfigNext);
                    }
                    boolean isHierarchical = false;
                    for (Map.Entry<Object, Object> entry : dynamicConfigNextCfg.entrySet()) {
                        String key = entry.getKey().toString().trim();
                        if (!key.startsWith("group") && !key.startsWith("weight")) continue;
                        isHierarchical = true;
                        break;
                    }
                    this.lastSeenQuorumVerifier = QuorumPeerConfig.createQuorumVerifier(dynamicConfigNextCfg, isHierarchical);
                }
                catch (IOException e) {
                    LOG.warn("NextQuorumVerifier is initiated to null");
                }
            }
        }
    }

    public static String getVersionFromFilename(String filename) {
        int i = filename.lastIndexOf(46);
        if (i < 0 || i >= filename.length()) {
            return null;
        }
        String hexVersion = filename.substring(i + 1);
        try {
            long version = Long.parseLong(hexVersion, 16);
            return Long.toHexString(version);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void parseProperties(Properties zkProp) throws IOException, ConfigException {
        int clientPort = 0;
        int secureClientPort = 0;
        String clientPortAddress = null;
        String secureClientPortAddress = null;
        VerifyingFileFactory vff = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().build();
        for (Map.Entry<Object, Object> entry : zkProp.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (key.equals("dataDir")) {
                this.dataDir = vff.create(value);
                continue;
            }
            if (key.equals("dataLogDir")) {
                this.dataLogDir = vff.create(value);
                continue;
            }
            if (key.equals("clientPort")) {
                clientPort = Integer.parseInt(value);
                continue;
            }
            if (key.equals("localSessionsEnabled")) {
                this.localSessionsEnabled = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("localSessionsUpgradingEnabled")) {
                this.localSessionsUpgradingEnabled = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("clientPortAddress")) {
                clientPortAddress = value.trim();
                continue;
            }
            if (key.equals("secureClientPort")) {
                secureClientPort = Integer.parseInt(value);
                continue;
            }
            if (key.equals("secureClientPortAddress")) {
                secureClientPortAddress = value.trim();
                continue;
            }
            if (key.equals("tickTime")) {
                this.tickTime = Integer.parseInt(value);
                continue;
            }
            if (key.equals("maxClientCnxns")) {
                this.maxClientCnxns = Integer.parseInt(value);
                continue;
            }
            if (key.equals("minSessionTimeout")) {
                this.minSessionTimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("maxSessionTimeout")) {
                this.maxSessionTimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("initLimit")) {
                this.initLimit = Integer.parseInt(value);
                continue;
            }
            if (key.equals("syncLimit")) {
                this.syncLimit = Integer.parseInt(value);
                continue;
            }
            if (key.equals("electionAlg")) {
                this.electionAlg = Integer.parseInt(value);
                continue;
            }
            if (key.equals("quorumListenOnAllIPs")) {
                this.quorumListenOnAllIPs = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("peerType")) {
                if (value.toLowerCase().equals("observer")) {
                    this.peerType = QuorumPeer.LearnerType.OBSERVER;
                    continue;
                }
                if (value.toLowerCase().equals("participant")) {
                    this.peerType = QuorumPeer.LearnerType.PARTICIPANT;
                    continue;
                }
                throw new ConfigException("Unrecognised peertype: " + value);
            }
            if (key.equals("syncEnabled")) {
                this.syncEnabled = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("dynamicConfigFile")) {
                this.dynamicConfigFileStr = value;
                continue;
            }
            if (key.equals("autopurge.snapRetainCount")) {
                this.snapRetainCount = Integer.parseInt(value);
                continue;
            }
            if (key.equals("autopurge.purgeInterval")) {
                this.purgeInterval = Integer.parseInt(value);
                continue;
            }
            if (key.equals("standaloneEnabled")) {
                if (value.toLowerCase().equals("true")) {
                    QuorumPeerConfig.setStandaloneEnabled(true);
                    continue;
                }
                if (value.toLowerCase().equals("false")) {
                    QuorumPeerConfig.setStandaloneEnabled(false);
                    continue;
                }
                throw new ConfigException("Invalid option for standalone mode. Choose 'true' or 'false.'");
            }
            if ((key.startsWith("server.") || key.startsWith("group") || key.startsWith("weight")) && zkProp.containsKey("dynamicConfigFile")) {
                throw new ConfigException("parameter: " + key + " must be in a separate dynamic config file");
            }
            System.setProperty("zookeeper." + key, value);
        }
        if (this.snapRetainCount < 3) {
            LOG.warn("Invalid autopurge.snapRetainCount: " + this.snapRetainCount + ". Defaulting to " + 3);
            this.snapRetainCount = 3;
        }
        if (this.dataDir == null) {
            throw new IllegalArgumentException("dataDir is not set");
        }
        if (this.dataLogDir == null) {
            this.dataLogDir = this.dataDir;
        }
        if (clientPort == 0) {
            LOG.info("clientPort is not set");
            if (clientPortAddress != null) {
                throw new IllegalArgumentException("clientPortAddress is set but clientPort is not set");
            }
        } else if (clientPortAddress != null) {
            this.clientPortAddress = new InetSocketAddress(InetAddress.getByName(clientPortAddress), clientPort);
            LOG.info("clientPortAddress is {}", (Object)this.clientPortAddress.toString());
        } else {
            this.clientPortAddress = new InetSocketAddress(clientPort);
            LOG.info("clientPortAddress is {}", (Object)this.clientPortAddress.toString());
        }
        if (secureClientPort == 0) {
            LOG.info("secureClientPort is not set");
            if (secureClientPortAddress != null) {
                throw new IllegalArgumentException("secureClientPortAddress is set but secureClientPort is not set");
            }
        } else if (secureClientPortAddress != null) {
            this.secureClientPortAddress = new InetSocketAddress(InetAddress.getByName(secureClientPortAddress), secureClientPort);
            LOG.info("secureClientPortAddress is {}", (Object)this.secureClientPortAddress.toString());
        } else {
            this.secureClientPortAddress = new InetSocketAddress(secureClientPort);
            LOG.info("secureClientPortAddress is {}", (Object)this.secureClientPortAddress.toString());
        }
        if (this.secureClientPortAddress != null) {
            this.configureSSLAuth();
        }
        if (this.tickTime == 0) {
            throw new IllegalArgumentException("tickTime is not set");
        }
        this.minSessionTimeout = this.minSessionTimeout == -1 ? this.tickTime * 2 : this.minSessionTimeout;
        int n = this.maxSessionTimeout = this.maxSessionTimeout == -1 ? this.tickTime * 20 : this.maxSessionTimeout;
        if (this.minSessionTimeout > this.maxSessionTimeout) {
            throw new IllegalArgumentException("minSessionTimeout must not be larger than maxSessionTimeout");
        }
        if (this.dynamicConfigFileStr == null) {
            this.setupQuorumPeerConfig(zkProp, true);
            if (this.isDistributed()) {
                this.backupOldConfig();
            }
        }
    }

    private void configureSSLAuth() throws ConfigException {
        String sslAuthProp = "zookeeper.authProvider." + System.getProperty("zookeeper.ssl.authProvider", "x509");
        if (System.getProperty(sslAuthProp) == null) {
            if ("zookeeper.authProvider.x509".equals(sslAuthProp)) {
                System.setProperty("zookeeper.authProvider.x509", "org.apache.zookeeper.server.auth.X509AuthenticationProvider");
            } else {
                throw new ConfigException("No auth provider configured for the SSL authentication scheme '" + System.getProperty("zookeeper.ssl.authProvider") + "'.");
            }
        }
    }

    private void backupOldConfig() throws IOException {
        new AtomicFileWritingIdiom(new File(this.configFileStr + ".bak"), new AtomicFileWritingIdiom.OutputStreamStatement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(OutputStream output) throws IOException {
                try (InputStream input = null;){
                    int bytesRead;
                    input = new FileInputStream(new File(QuorumPeerConfig.this.configFileStr));
                    byte[] buf = new byte[1024];
                    while ((bytesRead = input.read(buf)) > 0) {
                        output.write(buf, 0, bytesRead);
                    }
                }
            }
        });
    }

    public static void writeDynamicConfig(String dynamicConfigFilename, final QuorumVerifier qv, final boolean needKeepVersion) throws IOException {
        new AtomicFileWritingIdiom(new File(dynamicConfigFilename), new AtomicFileWritingIdiom.WriterStatement(){

            @Override
            public void write(Writer out) throws IOException {
                Properties cfg = new Properties();
                cfg.load(new StringReader(qv.toString()));
                ArrayList<String> servers = new ArrayList<String>();
                for (Map.Entry<Object, Object> entry : cfg.entrySet()) {
                    String key = entry.getKey().toString().trim();
                    if (!needKeepVersion && key.startsWith("version")) continue;
                    String value = entry.getValue().toString().trim();
                    servers.add(key.concat("=").concat(value));
                }
                Collections.sort(servers);
                out.write(StringUtils.joinStrings(servers, "\n"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editStaticConfig(String configFileStr, String dynamicFileStr, final boolean eraseClientPortAddress) throws IOException {
        if (configFileStr == null) {
            return;
        }
        File configFile = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().create(configFileStr);
        final File dynamicFile = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().create(dynamicFileStr);
        final Properties cfg = new Properties();
        try (FileInputStream in = new FileInputStream(configFile);){
            cfg.load(in);
        }
        new AtomicFileWritingIdiom(new File(configFileStr), new AtomicFileWritingIdiom.WriterStatement(){

            @Override
            public void write(Writer out) throws IOException {
                for (Map.Entry<Object, Object> entry : cfg.entrySet()) {
                    String key = entry.getKey().toString().trim();
                    if (key.startsWith("server.") || key.startsWith("group") || key.startsWith("weight") || key.startsWith("dynamicConfigFile") || eraseClientPortAddress && (key.startsWith("clientPort") || key.startsWith("clientPortAddress"))) continue;
                    String value = entry.getValue().toString().trim();
                    out.write(key.concat("=").concat(value).concat("\n"));
                }
                String dynamicConfigFilePath = PathUtils.normalizeFileSystemPath(dynamicFile.getCanonicalPath());
                out.write("dynamicConfigFile=".concat(dynamicConfigFilePath).concat("\n"));
            }
        });
    }

    public static void deleteFile(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            try {
                f.delete();
            }
            catch (Exception e) {
                LOG.warn("deleting " + filename + " failed");
            }
        }
    }

    private static QuorumVerifier createQuorumVerifier(Properties dynamicConfigProp, boolean isHierarchical) throws ConfigException {
        if (isHierarchical) {
            return new QuorumHierarchical(dynamicConfigProp);
        }
        return new QuorumMaj(dynamicConfigProp);
    }

    void setupQuorumPeerConfig(Properties prop, boolean configBackwardCompatibilityMode) throws IOException, ConfigException {
        this.quorumVerifier = QuorumPeerConfig.parseDynamicConfig(prop, this.electionAlg, true, configBackwardCompatibilityMode);
        this.setupMyId();
        this.setupClientPort();
        this.setupPeerType();
        this.checkValidity();
    }

    public static QuorumVerifier parseDynamicConfig(Properties dynamicConfigProp, int eAlg, boolean warnings, boolean configBackwardCompatibilityMode) throws IOException, ConfigException {
        boolean isHierarchical = false;
        for (Map.Entry<Object, Object> entry : dynamicConfigProp.entrySet()) {
            String key = entry.getKey().toString().trim();
            if (key.startsWith("group") || key.startsWith("weight")) {
                isHierarchical = true;
                continue;
            }
            if (configBackwardCompatibilityMode || key.startsWith("server.") || key.equals("version")) continue;
            LOG.info(dynamicConfigProp.toString());
            throw new ConfigException("Unrecognised parameter: " + key);
        }
        QuorumVerifier qv = QuorumPeerConfig.createQuorumVerifier(dynamicConfigProp, isHierarchical);
        int numParticipators = qv.getVotingMembers().size();
        int numObservers = qv.getObservingMembers().size();
        if (numParticipators == 0) {
            if (!standaloneEnabled) {
                throw new IllegalArgumentException("standaloneEnabled = false then number of participants should be >0");
            }
            if (numObservers > 0) {
                throw new IllegalArgumentException("Observers w/o participants is an invalid configuration");
            }
        } else if (numParticipators == 1 && standaloneEnabled) {
            LOG.error("Invalid configuration, only one server specified (ignoring)");
            if (numObservers > 0) {
                throw new IllegalArgumentException("Observers w/o quorum is an invalid configuration");
            }
        } else {
            if (warnings) {
                if (numParticipators <= 2) {
                    LOG.warn("No server failure will be tolerated. You need at least 3 servers.");
                } else if (numParticipators % 2 == 0) {
                    LOG.warn("Non-optimial configuration, consider an odd number of servers.");
                }
            }
            if (eAlg != 0) {
                for (QuorumPeer.QuorumServer s : qv.getVotingMembers().values()) {
                    if (s.electionAddr != null) continue;
                    throw new IllegalArgumentException("Missing election port for server: " + s.id);
                }
            }
        }
        return qv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupMyId() throws IOException {
        String myIdString;
        File myIdFile = new File(this.dataDir, "myid");
        if (!myIdFile.isFile()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(myIdFile));){
            myIdString = br.readLine();
        }
        try {
            this.serverId = Long.parseLong(myIdString);
            MDC.put((String)"myid", (String)myIdString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("serverid " + myIdString + " is not a number");
        }
    }

    private void setupClientPort() throws ConfigException {
        if (this.serverId == -1L) {
            return;
        }
        QuorumPeer.QuorumServer qs = this.quorumVerifier.getAllMembers().get(this.serverId);
        if (this.clientPortAddress != null && qs != null && qs.clientAddr != null && (!this.clientPortAddress.getAddress().isAnyLocalAddress() && !this.clientPortAddress.equals(qs.clientAddr) || this.clientPortAddress.getAddress().isAnyLocalAddress() && this.clientPortAddress.getPort() != qs.clientAddr.getPort())) {
            throw new ConfigException("client address for this server (id = " + this.serverId + ") in static config file is " + this.clientPortAddress + " is different from client address found in dynamic file: " + qs.clientAddr);
        }
        if (qs != null && qs.clientAddr != null) {
            this.clientPortAddress = qs.clientAddr;
        }
    }

    private void setupPeerType() {
        QuorumPeer.LearnerType roleByServersList;
        QuorumPeer.LearnerType learnerType = roleByServersList = this.quorumVerifier.getObservingMembers().containsKey(this.serverId) ? QuorumPeer.LearnerType.OBSERVER : QuorumPeer.LearnerType.PARTICIPANT;
        if (roleByServersList != this.peerType) {
            LOG.warn("Peer type from servers list (" + (Object)((Object)roleByServersList) + ") doesn't match peerType (" + (Object)((Object)this.peerType) + "). Defaulting to servers list.");
            this.peerType = roleByServersList;
        }
    }

    public void checkValidity() throws IOException, ConfigException {
        if (this.isDistributed()) {
            if (this.initLimit == 0) {
                throw new IllegalArgumentException("initLimit is not set");
            }
            if (this.syncLimit == 0) {
                throw new IllegalArgumentException("syncLimit is not set");
            }
            if (this.serverId == -1L) {
                throw new IllegalArgumentException("myid file is missing");
            }
        }
    }

    public InetSocketAddress getClientPortAddress() {
        return this.clientPortAddress;
    }

    public InetSocketAddress getSecureClientPortAddress() {
        return this.secureClientPortAddress;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getDataLogDir() {
        return this.dataLogDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public boolean areLocalSessionsEnabled() {
        return this.localSessionsEnabled;
    }

    public boolean isLocalSessionsUpgradingEnabled() {
        return this.localSessionsUpgradingEnabled;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public int getSyncLimit() {
        return this.syncLimit;
    }

    public int getElectionAlg() {
        return this.electionAlg;
    }

    public int getElectionPort() {
        return this.electionPort;
    }

    public int getSnapRetainCount() {
        return this.snapRetainCount;
    }

    public int getPurgeInterval() {
        return this.purgeInterval;
    }

    public boolean getSyncEnabled() {
        return this.syncEnabled;
    }

    public QuorumVerifier getQuorumVerifier() {
        return this.quorumVerifier;
    }

    public QuorumVerifier getLastSeenQuorumVerifier() {
        return this.lastSeenQuorumVerifier;
    }

    public Map<Long, QuorumPeer.QuorumServer> getServers() {
        return Collections.unmodifiableMap(this.quorumVerifier.getAllMembers());
    }

    public long getServerId() {
        return this.serverId;
    }

    public boolean isDistributed() {
        return this.quorumVerifier != null && (!standaloneEnabled || this.quorumVerifier.getVotingMembers().size() > 1);
    }

    public QuorumPeer.LearnerType getPeerType() {
        return this.peerType;
    }

    public String getConfigFilename() {
        return this.configFileStr;
    }

    public Boolean getQuorumListenOnAllIPs() {
        return this.quorumListenOnAllIPs;
    }

    public static boolean isStandaloneEnabled() {
        return standaloneEnabled;
    }

    public static void setStandaloneEnabled(boolean enabled) {
        standaloneEnabled = enabled;
    }

    public static class ConfigException
    extends Exception {
        public ConfigException(String msg) {
            super(msg);
        }

        public ConfigException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

