/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.constraint;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.awaitility.constraint.HoldsPredicateWaitConstraint;
import org.awaitility.constraint.IntervalWaitConstraint;
import org.awaitility.constraint.WaitConstraint;

public class AtMostWaitConstraint
implements WaitConstraint {
    private final Duration atMostDuration;
    public static final AtMostWaitConstraint FOREVER = new AtMostWaitConstraint(ChronoUnit.FOREVER.getDuration());
    public static final AtMostWaitConstraint TEN_SECONDS = new AtMostWaitConstraint(Duration.ofSeconds(10L));

    AtMostWaitConstraint(Duration atMostDuration) {
        this.atMostDuration = atMostDuration;
    }

    @Override
    public Duration getMaxWaitTime() {
        return this.atMostDuration;
    }

    @Override
    public Duration getMinWaitTime() {
        return Duration.ZERO;
    }

    @Override
    public Duration getHoldPredicateTime() {
        return Duration.ZERO;
    }

    @Override
    public WaitConstraint withMinWaitTime(Duration minWaitTime) {
        return new IntervalWaitConstraint(minWaitTime, this.atMostDuration);
    }

    @Override
    public WaitConstraint withMaxWaitTime(Duration maxWaitTime) {
        return new AtMostWaitConstraint(maxWaitTime);
    }

    @Override
    public WaitConstraint withHoldPredicateTime(Duration holdConditionTime) {
        return new HoldsPredicateWaitConstraint(this.getMinWaitTime(), this.atMostDuration, holdConditionTime);
    }
}

