// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_cudacodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;

import static org.bytedeco.opencv.global.opencv_cudacodec.*;


/** \brief Different parameters for CUDA video encoder.
 */
@Namespace("cv::cudacodec") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_cudacodec.class)
public class EncoderParams extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public EncoderParams(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public EncoderParams(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public EncoderParams position(long position) {
        return (EncoderParams)super.position(position);
    }
    @Override public EncoderParams getPointer(long i) {
        return new EncoderParams((Pointer)this).offsetAddress(i);
    }

    /** NVVE_P_INTERVAL, */
    public native int P_Interval(); public native EncoderParams P_Interval(int setter);
    /** NVVE_IDR_PERIOD, */
    public native int IDR_Period(); public native EncoderParams IDR_Period(int setter);
    /** NVVE_DYNAMIC_GOP, */
    public native int DynamicGOP(); public native EncoderParams DynamicGOP(int setter);
    /** NVVE_RC_TYPE, */
    public native int RCType(); public native EncoderParams RCType(int setter);
    /** NVVE_AVG_BITRATE, */
    public native int AvgBitrate(); public native EncoderParams AvgBitrate(int setter);
    /** NVVE_PEAK_BITRATE, */
    public native int PeakBitrate(); public native EncoderParams PeakBitrate(int setter);
    /** NVVE_QP_LEVEL_INTRA, */
    public native int QP_Level_Intra(); public native EncoderParams QP_Level_Intra(int setter);
    /** NVVE_QP_LEVEL_INTER_P, */
    public native int QP_Level_InterP(); public native EncoderParams QP_Level_InterP(int setter);
    /** NVVE_QP_LEVEL_INTER_B, */
    public native int QP_Level_InterB(); public native EncoderParams QP_Level_InterB(int setter);
    /** NVVE_DEBLOCK_MODE, */
    public native int DeblockMode(); public native EncoderParams DeblockMode(int setter);
    /** NVVE_PROFILE_LEVEL, */
    public native int ProfileLevel(); public native EncoderParams ProfileLevel(int setter);
    /** NVVE_FORCE_INTRA, */
    public native int ForceIntra(); public native EncoderParams ForceIntra(int setter);
    /** NVVE_FORCE_IDR, */
    public native int ForceIDR(); public native EncoderParams ForceIDR(int setter);
    /** NVVE_CLEAR_STAT, */
    public native int ClearStat(); public native EncoderParams ClearStat(int setter);
    /** NVVE_SET_DEINTERLACE, */
    public native int DIMode(); public native EncoderParams DIMode(int setter);
    /** NVVE_PRESETS, */
    public native int Presets(); public native EncoderParams Presets(int setter);
    /** NVVE_DISABLE_CABAC, */
    public native int DisableCabac(); public native EncoderParams DisableCabac(int setter);
    /** NVVE_CONFIGURE_NALU_FRAMING_TYPE */
    public native int NaluFramingType(); public native EncoderParams NaluFramingType(int setter);
    /** NVVE_DISABLE_SPS_PPS */
    public native int DisableSPSPPS(); public native EncoderParams DisableSPSPPS(int setter);

    public EncoderParams() { super((Pointer)null); allocate(); }
    private native void allocate();
    /** \brief Constructors.
    <p>
    @param configFile Config file name.
    <p>
    Creates default parameters or reads parameters from config file.
     */
    public EncoderParams(@Str BytePointer configFile) { super((Pointer)null); allocate(configFile); }
    private native void allocate(@Str BytePointer configFile);
    public EncoderParams(@Str String configFile) { super((Pointer)null); allocate(configFile); }
    private native void allocate(@Str String configFile);

    /** \brief Reads parameters from config file.
    <p>
    @param configFile Config file name.
     */
    public native void load(@Str BytePointer configFile);
    public native void load(@Str String configFile);
    /** \brief Saves parameters to config file.
    <p>
    @param configFile Config file name.
     */
    public native void save(@Str BytePointer configFile);
    public native void save(@Str String configFile);
}
