// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_dnn;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.opencv.global.opencv_dnn.*;

@Name("std::vector<std::vector<cv::dnn::MatShape> >") @Properties(inherit = org.bytedeco.opencv.presets.opencv_dnn.class)
public class MatShapeVectorVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MatShapeVectorVector(Pointer p) { super(p); }
    public MatShapeVectorVector(MatShapeVector value) { this(1); put(0, value); }
    public MatShapeVectorVector(MatShapeVector ... array) { this(array.length); put(array); }
    public MatShapeVectorVector()       { allocate();  }
    public MatShapeVectorVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator =") @ByRef MatShapeVectorVector put(@ByRef MatShapeVectorVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index(function = "at") public native @ByRef MatShapeVector get(@Cast("size_t") long i);
    public native MatShapeVectorVector put(@Cast("size_t") long i, MatShapeVector value);

    public native @ByVal Iterator insert(@ByVal Iterator pos, @ByRef MatShapeVector value);
    public native @ByVal Iterator erase(@ByVal Iterator pos);
    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator ++") @ByRef Iterator increment();
        public native @Name("operator ==") boolean equals(@ByRef Iterator it);
        public native @Name("operator *") @ByRef @Const MatShapeVector get();
    }

    public MatShapeVector[] get() {
        MatShapeVector[] array = new MatShapeVector[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; i++) {
            array[i] = get(i);
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.toString(get());
    }

    public MatShapeVector pop_back() {
        long size = size();
        MatShapeVector value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public MatShapeVectorVector push_back(MatShapeVector value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public MatShapeVectorVector put(MatShapeVector value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public MatShapeVectorVector put(MatShapeVector ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

