// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tesseract.global;

import org.bytedeco.tesseract.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.leptonica.*;
import static org.bytedeco.leptonica.global.lept.*;

public class tesseract extends org.bytedeco.tesseract.presets.tesseract {
    static { Loader.load(); }

// Targeting ../StringFloatPairVectorVector.java


// Parsed from tesseract/platform.h

///////////////////////////////////////////////////////////////////////
// File:        platform.h
// Description: Place holder
//
// (C) Copyright 2006, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef TESSERACT_CCUTIL_PLATFORM_H_
// #define TESSERACT_CCUTIL_PLATFORM_H_

// #define DLLSYM
// #ifndef _WIN32
// #  ifdef __cplusplus
// #    include <climits>
// #  else /* C compiler*/
// #    include <limits.h>
// #  endif /* __cplusplus */
// #  ifndef PATH_MAX
public static final int MAX_PATH = 4096;
// #  else
// #  endif
// #endif

// #if defined(_WIN32) || defined(__CYGWIN__)
// #  if defined(TESS_EXPORTS)
// #    define TESS_API __declspec(dllexport)
// #  elif defined(TESS_IMPORTS)
// #    define TESS_API __declspec(dllimport)
// #  else
// #    define TESS_API
// #  endif
// #  define TESS_LOCAL
// #else
// #  if __GNUC__ >= 4
// #    if defined(TESS_EXPORTS) || defined(TESS_IMPORTS)
// #      define TESS_API __attribute__((visibility("default")))
// #      define TESS_LOCAL __attribute__((visibility("hidden")))
// #    else
// #      define TESS_API
// #      define TESS_LOCAL
// #    endif
// #  else
// #    define TESS_API
// #    define TESS_LOCAL
// #  endif
// #endif

// #endif  // TESSERACT_CCUTIL_PLATFORM_H_


// Parsed from tesseract/apitypes.h

///////////////////////////////////////////////////////////////////////
// File:        apitypes.h
// Description: Types used in both the API and internally
// Author:      Ray Smith
// Created:     Wed Mar 03 09:22:53 PST 2010
//
// (C) Copyright 2010, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef TESSERACT_API_APITYPES_H_
// #define TESSERACT_API_APITYPES_H_

// #include "publictypes.h"

// The types used by the API and Page/ResultIterator can be found in:
//   ccstruct/publictypes.h
//   ccmain/resultiterator.h
//   ccmain/pageiterator.h
// API interfaces and API users should be sure to include this file, rather
// than the lower-level one, and lower-level code should be sure to include
// only the lower-level file.

// #endif  // TESSERACT_API_APITYPES_H_


// Parsed from tesseract/unichar.h

///////////////////////////////////////////////////////////////////////
// File:        unichar.h
// Description: Unicode character/ligature class.
// Author:      Ray Smith
//
// (C) Copyright 2006, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef TESSERACT_CCUTIL_UNICHAR_H_
// #define TESSERACT_CCUTIL_UNICHAR_H_

// #include <memory.h>
// #include <cstring>
// #include <string>
// #include <vector>
// #include "platform.h"

// Maximum number of characters that can be stored in a UNICHAR. Must be
// at least 4. Must not exceed 31 without changing the coding of length.
public static final int UNICHAR_LEN = 30;

// TODO(rays) Move these to the tesseract namespace.
// A UNICHAR_ID is the unique id of a unichar.

// A variable to indicate an invalid or uninitialized unichar id.
@MemberGetter public static native int INVALID_UNICHAR_ID();
public static final int INVALID_UNICHAR_ID = INVALID_UNICHAR_ID();
// A special unichar that corresponds to INVALID_UNICHAR_ID.
@MemberGetter public static native @Cast("const char") byte INVALID_UNICHAR(int i);
@MemberGetter public static native @Cast("const char*") BytePointer INVALID_UNICHAR();

/** enum StrongScriptDirection */
public static final int
  DIR_NEUTRAL = 0,        // Text contains only neutral characters.
  DIR_LEFT_TO_RIGHT = 1,  // Text contains no Right-to-Left characters.
  DIR_RIGHT_TO_LEFT = 2,  // Text contains no Left-to-Right characters.
  DIR_MIX = 3;            // Text contains a mixture of left-to-right
                          // and right-to-left characters.
// Targeting ../UNICHAR.java



  // namespace tesseract

// #endif  // TESSERACT_CCUTIL_UNICHAR_H_


// Parsed from tesseract/tesscallback.h

///////////////////////////////////////////////////////////////////////
// File:        tesscallback.h
// Description: classes and functions to replace pointer-to-functions
// Author:      Samuel Charron
//
// (C) Copyright 2006, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef TESS_CALLBACK_SPECIALIZATIONS_H_
// #define TESS_CALLBACK_SPECIALIZATIONS_H_
// Targeting ../TessClosure.java



// #ifndef SWIG
// #endif

// Specified by TR1 [4.7.2] Reference modifications.

// Identity<T>::type is a typedef of T. Useful for preventing the
// compiler from inferring the type of an argument in templates.

// #ifndef SWIG
// #endif

// #ifndef SWIG
// Targeting ../CharClearCallback.java


// Targeting ../StringClearCallback.java


// Targeting ../IntClearCallback.java


// Targeting ../DeleteCallback.java


// Targeting ../CharCompareCallback.java


// Targeting ../CharWriteCallback.java


// Targeting ../CharReadCallback.java


// Targeting ../StringCompareCallback.java


// Targeting ../StringWriteCallback.java


// Targeting ../StringReadCallback.java


// Targeting ../IntCompareCallback.java


// Targeting ../IntWriteCallback.java


// Targeting ../IntReadCallback.java


// Targeting ../TruthCallback3.java


// Targeting ../TruthCallback4.java



// #ifndef SWIG
// #endif

// #ifndef SWIG
// #endif

// #ifndef SWIG
// #endif

// #ifndef SWIG
// #endif

// #ifndef SWIG
// #endif

// #ifndef SWIG
// #endif

// #endif  // TESS_CALLBACK_SPECIALIZATIONS_H_


// Parsed from tesseract/publictypes.h

///////////////////////////////////////////////////////////////////////
// File:        publictypes.h
// Description: Types used in both the API and internally
// Author:      Ray Smith
// Created:     Wed Mar 03 09:22:53 PST 2010
//
// (C) Copyright 2010, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef TESSERACT_CCSTRUCT_PUBLICTYPES_H_
// #define TESSERACT_CCSTRUCT_PUBLICTYPES_H_

// This file contains types that are used both by the API and internally
// to Tesseract. In order to decouple the API from Tesseract and prevent cyclic
// dependencies, THIS FILE SHOULD NOT DEPEND ON ANY OTHER PART OF TESSERACT.
// Restated: It is OK for low-level Tesseract files to include publictypes.h,
// but not for the low-level tesseract code to include top-level API code.
// This file should not use other Tesseract types, as that would drag
// their includes into the API-level.
// API-level code should include apitypes.h in preference to this file.

/** Number of printers' points in an inch. The unit of the pointsize return. */
@MemberGetter public static native int kPointsPerInch();
/**
 * Minimum believable resolution. Used as a default if there is no other
 * information, as it is safer to under-estimate than over-estimate.
 */
@MemberGetter public static native int kMinCredibleResolution();
/** Maximum believable resolution.  */
@MemberGetter public static native int kMaxCredibleResolution();
/**
 * Ratio between median blob size and likely resolution. Used to estimate
 * resolution when none is provided. This is basically 1/usual text size in
 * inches.  */
@MemberGetter public static native int kResolutionEstimationFactor();

/**
 * Possible types for a POLY_BLOCK or ColPartition.
 * Must be kept in sync with kPBColors in polyblk.cpp and PTIs*Type functions
 * below, as well as kPolyBlockNames in publictypes.cpp.
 * Used extensively by ColPartition, and POLY_BLOCK.
*/
/** enum PolyBlockType */
public static final int
  PT_UNKNOWN = 0,        // Type is not yet known. Keep as the first element.
  PT_FLOWING_TEXT = 1,   // Text that lives inside a column.
  PT_HEADING_TEXT = 2,   // Text that spans more than one column.
  PT_PULLOUT_TEXT = 3,   // Text that is in a cross-column pull-out region.
  PT_EQUATION = 4,       // Partition belonging to an equation region.
  PT_INLINE_EQUATION = 5,  // Partition has inline equation.
  PT_TABLE = 6,          // Partition belonging to a table region.
  PT_VERTICAL_TEXT = 7,  // Text-line runs vertically.
  PT_CAPTION_TEXT = 8,   // Text that belongs to an image.
  PT_FLOWING_IMAGE = 9,  // Image that lives inside a column.
  PT_HEADING_IMAGE = 10,  // Image that spans more than one column.
  PT_PULLOUT_IMAGE = 11,  // Image that is in a cross-column pull-out region.
  PT_HORZ_LINE = 12,      // Horizontal Line.
  PT_VERT_LINE = 13,      // Vertical Line.
  PT_NOISE = 14,          // Lies outside of any column.
  PT_COUNT = 15;

/** Returns true if PolyBlockType is of horizontal line type */
public static native @Cast("bool") boolean PTIsLineType(@Cast("PolyBlockType") int type);
/** Returns true if PolyBlockType is of image type */
public static native @Cast("bool") boolean PTIsImageType(@Cast("PolyBlockType") int type);
/** Returns true if PolyBlockType is of text type */
public static native @Cast("bool") boolean PTIsTextType(@Cast("PolyBlockType") int type);
// Returns true if PolyBlockType is of pullout(inter-column) type
public static native @Cast("bool") boolean PTIsPulloutType(@Cast("PolyBlockType") int type);

/** String name for each block type. Keep in sync with PolyBlockType. */

/**
 *  +------------------+  Orientation Example:
 *  | 1 Aaaa Aaaa Aaaa |  ====================
 *  | Aaa aa aaa aa    |  To left is a diagram of some (1) English and
 *  | aaaaaa A aa aaa. |  (2) Chinese text and a (3) photo credit.
 *  |                2 |
 *  |   #######  c c C |  Upright Latin characters are represented as A and a.
 *  |   #######  c c c |  '<' represents a latin character rotated
 *  | < #######  c c c |      anti-clockwise 90 degrees.
 *  | < #######  c   c |
 *  | < #######  .   c |  Upright Chinese characters are represented C and c.
 *  | 3 #######      c |
 *  +------------------+  NOTA BENE: enum values here should match goodoc.proto
 <p>
 * If you orient your head so that "up" aligns with Orientation,
 * then the characters will appear "right side up" and readable.
 *
 * In the example above, both the English and Chinese paragraphs are oriented
 * so their "up" is the top of the page (page up).  The photo credit is read
 * with one's head turned leftward ("up" is to page left).
 *
 * The values of this enum match the convention of Tesseract's osdetect.h
*/
/** enum tesseract::Orientation */
public static final int
  ORIENTATION_PAGE_UP = 0,
  ORIENTATION_PAGE_RIGHT = 1,
  ORIENTATION_PAGE_DOWN = 2,
  ORIENTATION_PAGE_LEFT = 3;

/**
 * The grapheme clusters within a line of text are laid out logically
 * in this direction, judged when looking at the text line rotated so that
 * its Orientation is "page up".
 *
 * For English text, the writing direction is left-to-right.  For the
 * Chinese text in the above example, the writing direction is top-to-bottom.
*/
/** enum tesseract::WritingDirection */
public static final int
  WRITING_DIRECTION_LEFT_TO_RIGHT = 0,
  WRITING_DIRECTION_RIGHT_TO_LEFT = 1,
  WRITING_DIRECTION_TOP_TO_BOTTOM = 2;

/**
 * The text lines are read in the given sequence.
 *
 * In English, the order is top-to-bottom.
 * In Chinese, vertical text lines are read right-to-left.  Mongolian is
 * written in vertical columns top to bottom like Chinese, but the lines
 * order left-to right.
 *
 * Note that only some combinations make sense.  For example,
 * WRITING_DIRECTION_LEFT_TO_RIGHT implies TEXTLINE_ORDER_TOP_TO_BOTTOM
*/
/** enum tesseract::TextlineOrder */
public static final int
  TEXTLINE_ORDER_LEFT_TO_RIGHT = 0,
  TEXTLINE_ORDER_RIGHT_TO_LEFT = 1,
  TEXTLINE_ORDER_TOP_TO_BOTTOM = 2;

/**
 * Possible modes for page layout analysis. These *must* be kept in order
 * of decreasing amount of layout analysis to be done, except for OSD_ONLY,
 * so that the inequality test macros below work.
*/
/** enum tesseract::PageSegMode */
public static final int
  /** Orientation and script detection only. */
  PSM_OSD_ONLY = 0,
  /** Automatic page segmentation with orientation and
 *  script detection. (OSD) */
  PSM_AUTO_OSD = 1,
  /** Automatic page segmentation, but no OSD, or OCR. */
  PSM_AUTO_ONLY = 2,
  /** Fully automatic page segmentation, but no OSD. */
  PSM_AUTO = 3,
  /** Assume a single column of text of variable sizes. */
  PSM_SINGLE_COLUMN = 4,
  /** Assume a single uniform block of vertically
 *  aligned text. */
  PSM_SINGLE_BLOCK_VERT_TEXT = 5,
  /** Assume a single uniform block of text. (Default.) */
  PSM_SINGLE_BLOCK = 6,
  /** Treat the image as a single text line. */
  PSM_SINGLE_LINE = 7,
  /** Treat the image as a single word. */
  PSM_SINGLE_WORD = 8,
  /** Treat the image as a single word in a circle. */
  PSM_CIRCLE_WORD = 9,
  /** Treat the image as a single character. */
  PSM_SINGLE_CHAR = 10,
  /** Find as much text as possible in no particular order. */
  PSM_SPARSE_TEXT = 11,
  /** Sparse text with orientation and script det. */
  PSM_SPARSE_TEXT_OSD = 12,
  /** Treat the image as a single text line, bypassing
 *  hacks that are Tesseract-specific. */
  PSM_RAW_LINE = 13,

  /** Number of enum entries. */
  PSM_COUNT = 14;

/**
 * Inline functions that act on a PageSegMode to determine whether components of
 * layout analysis are enabled.
 * *Depend critically on the order of elements of PageSegMode.*
 * NOTE that arg is an int for compatibility with INT_PARAM.
*/
@Namespace("tesseract") public static native @Cast("bool") boolean PSM_OSD_ENABLED(int pageseg_mode);
@Namespace("tesseract") public static native @Cast("bool") boolean PSM_ORIENTATION_ENABLED(int pageseg_mode);
@Namespace("tesseract") public static native @Cast("bool") boolean PSM_COL_FIND_ENABLED(int pageseg_mode);
@Namespace("tesseract") public static native @Cast("bool") boolean PSM_SPARSE(int pageseg_mode);
@Namespace("tesseract") public static native @Cast("bool") boolean PSM_BLOCK_FIND_ENABLED(int pageseg_mode);
@Namespace("tesseract") public static native @Cast("bool") boolean PSM_LINE_FIND_ENABLED(int pageseg_mode);
@Namespace("tesseract") public static native @Cast("bool") boolean PSM_WORD_FIND_ENABLED(int pageseg_mode);

/**
 * enum of the elements of the page hierarchy, used in ResultIterator
 * to provide functions that operate on each level without having to
 * have 5x as many functions.
*/
/** enum tesseract::PageIteratorLevel */
public static final int
  RIL_BLOCK = 0,     // Block of text/image/separator line.
  RIL_PARA = 1,      // Paragraph within a block.
  RIL_TEXTLINE = 2,  // Line within a paragraph.
  RIL_WORD = 3,      // Word within a textline.
  RIL_SYMBOL = 4;     // Symbol/character within a word.

/**
 * JUSTIFICATION_UNKNOWN
 *   The alignment is not clearly one of the other options.  This could happen
 *   for example if there are only one or two lines of text or the text looks
 *   like source code or poetry.
 *
 * NOTA BENE: Fully justified paragraphs (text aligned to both left and right
 *    margins) are marked by Tesseract with JUSTIFICATION_LEFT if their text
 *    is written with a left-to-right script and with JUSTIFICATION_RIGHT if
 *    their text is written in a right-to-left script.
 *
 * Interpretation for text read in vertical lines:
 *   "Left" is wherever the starting reading position is.
 *
 * JUSTIFICATION_LEFT
 *   Each line, except possibly the first, is flush to the same left tab stop.
 *
 * JUSTIFICATION_CENTER
 *   The text lines of the paragraph are centered about a line going
 *   down through their middle of the text lines.
 *
 * JUSTIFICATION_RIGHT
 *   Each line, except possibly the first, is flush to the same right tab stop.
 */
/** enum tesseract::ParagraphJustification */
public static final int
  JUSTIFICATION_UNKNOWN = 0,
  JUSTIFICATION_LEFT = 1,
  JUSTIFICATION_CENTER = 2,
  JUSTIFICATION_RIGHT = 3;

/**
 * When Tesseract/Cube is initialized we can choose to instantiate/load/run
 * only the Tesseract part, only the Cube part or both along with the combiner.
 * The preference of which engine to use is stored in tessedit_ocr_engine_mode.
 *
 * ATTENTION: When modifying this enum, please make sure to make the
 * appropriate changes to all the enums mirroring it (e.g. OCREngine in
 * cityblock/workflow/detection/detection_storage.proto). Such enums will
 * mention the connection to OcrEngineMode in the comments.
*/
/** enum tesseract::OcrEngineMode */
public static final int
  OEM_TESSERACT_ONLY = 0,           // Run Tesseract only - fastest; deprecated
  OEM_LSTM_ONLY = 1,                // Run just the LSTM line recognizer.
  OEM_TESSERACT_LSTM_COMBINED = 2,  // Run the LSTM recognizer, but allow fallback
                                // to Tesseract when things get difficult.
                                // deprecated
  OEM_DEFAULT = 3,                  // Specify this mode when calling init_*(),
                                // to indicate that any of the above modes
                                // should be automatically inferred from the
                                // variables in the language-specific config,
                                // command-line configs, or if not specified
                                // in any of the above should be set to the
                                // default OEM_TESSERACT_ONLY.
  OEM_COUNT = 4;                     // Number of OEMs

  // namespace tesseract.

// #endif  // TESSERACT_CCSTRUCT_PUBLICTYPES_H_


// Parsed from tesseract/thresholder.h

///////////////////////////////////////////////////////////////////////
// File:        thresholder.h
// Description: Base API for thresholding images in tesseract.
// Author:      Ray Smith
//
// (C) Copyright 2008, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef TESSERACT_CCMAIN_THRESHOLDER_H_
// #define TESSERACT_CCMAIN_THRESHOLDER_H_

// #include "platform.h"
// #include "publictypes.h"
// Targeting ../ImageThresholder.java



  // namespace tesseract.

// #endif  // TESSERACT_CCMAIN_THRESHOLDER_H_


// Parsed from tesseract/pageiterator.h

///////////////////////////////////////////////////////////////////////
// File:        pageiterator.h
// Description: Iterator for tesseract page structure that avoids using
//              tesseract internal data structures.
// Author:      Ray Smith
// Created:     Fri Feb 26 11:01:06 PST 2010
//
// (C) Copyright 2010, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef TESSERACT_CCMAIN_PAGEITERATOR_H_
// #define TESSERACT_CCMAIN_PAGEITERATOR_H_

// #include "platform.h"
// #include "publictypes.h"
// Targeting ../BlamerBundle.java


// Targeting ../C_BLOB_IT.java


// Targeting ../PAGE_RES.java


// Targeting ../PAGE_RES_IT.java


// Targeting ../WERD.java


// Targeting ../Tesseract.java


// Targeting ../PageIterator.java



  // namespace tesseract.

// #endif  // TESSERACT_CCMAIN_PAGEITERATOR_H_


// Parsed from tesseract/ltrresultiterator.h

///////////////////////////////////////////////////////////////////////
// File:        ltrresultiterator.h
// Description: Iterator for tesseract results in strict left-to-right
//              order that avoids using tesseract internal data structures.
// Author:      Ray Smith
// Created:     Fri Feb 26 11:01:06 PST 2010
//
// (C) Copyright 2010, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef TESSERACT_CCMAIN_LTR_RESULT_ITERATOR_H_
// #define TESSERACT_CCMAIN_LTR_RESULT_ITERATOR_H_

// #include "pageiterator.h"  // for PageIterator
// #include "platform.h"      // for TESS_API
// #include "publictypes.h"   // for PageIteratorLevel
// #include "unichar.h"
// Targeting ../BLOB_CHOICE_IT.java


// Targeting ../WERD_RES.java


// Targeting ../LTRResultIterator.java


// Targeting ../ChoiceIterator.java



  // namespace tesseract.

// #endif  // TESSERACT_CCMAIN_LTR_RESULT_ITERATOR_H_


// Parsed from tesseract/resultiterator.h

///////////////////////////////////////////////////////////////////////
// File:        resultiterator.h
// Description: Iterator for tesseract results that is capable of
//              iterating in proper reading order over Bi Directional
//              (e.g. mixed Hebrew and English) text.
// Author:      David Eger
// Created:     Fri May 27 13:58:06 PST 2011
//
// (C) Copyright 2011, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef TESSERACT_CCMAIN_RESULT_ITERATOR_H_
// #define TESSERACT_CCMAIN_RESULT_ITERATOR_H_

// #include <set>                  // for std::pair
// #include <vector>               // for std::vector
// #include "ltrresultiterator.h"  // for LTRResultIterator
// #include "platform.h"           // for TESS_API, TESS_LOCAL
// #include "publictypes.h"        // for PageIteratorLevel
// #include "unichar.h"
// Targeting ../ResultIterator.java



  // namespace tesseract.

// #endif  // TESSERACT_CCMAIN_RESULT_ITERATOR_H_


// Parsed from tesseract/serialis.h

/**********************************************************************
 * File:        serialis.h  (Formerly serialmac.h)
 * Description: Inline routines and macros for serialisation functions
 * Author:      Phil Cheatle
 *
 * (C) Copyright 1990, Hewlett-Packard Ltd.
 ** Licensed under the Apache License, Version 2.0 (the "License");
 ** you may not use this file except in compliance with the License.
 ** You may obtain a copy of the License at
 ** http://www.apache.org/licenses/LICENSE-2.0
 ** Unless required by applicable law or agreed to in writing, software
 ** distributed under the License is distributed on an "AS IS" BASIS,
 ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ** See the License for the specific language governing permissions and
 ** limitations under the License.
 *
 **********************************************************************/

// #ifndef SERIALIS_H
// #define SERIALIS_H

// #include <cstdint>  // uint8_t
// #include <cstdio>
// #include <cstdlib>
// #include <cstring>

/***********************************************************************
  QUOTE_IT   MACRO DEFINITION
  ===========================
Replace <parm> with "<parm>".  <parm> may be an arbitrary number of tokens
***********************************************************************/

// #define QUOTE_IT(parm) #parm

// Return number of elements of an array.
// Targeting ../FileReader.java


// Targeting ../FileWriter.java



// Deserialize data from file.
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, @Cast("char*") BytePointer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, @Cast("char*") BytePointer data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, @Cast("char*") ByteBuffer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, @Cast("char*") ByteBuffer data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, @Cast("char*") byte[] data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, @Cast("char*") byte[] data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, FloatPointer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, FloatPointer data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, FloatBuffer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, FloatBuffer data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, float[] data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, float[] data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, ShortPointer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, ShortPointer data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, ShortBuffer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, ShortBuffer data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, short[] data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, short[] data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, IntPointer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, IntPointer data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, IntBuffer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, IntBuffer data);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, int[] data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean DeSerialize(@Cast("FILE*") Pointer fp, int[] data);

// Serialize data to file.
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Cast("const char*") BytePointer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Cast("const char*") BytePointer data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, String data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, String data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const FloatPointer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const FloatPointer data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const FloatBuffer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const FloatBuffer data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const float[] data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const float[] data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const ByteBuffer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const ByteBuffer data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const byte[] data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const byte[] data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const ShortPointer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const ShortPointer data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const ShortBuffer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const ShortBuffer data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const short[] data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const short[] data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const IntPointer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const IntPointer data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const IntBuffer data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const IntBuffer data);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const int[] data, @Cast("size_t") long n/*=1*/);
@Namespace("tesseract") public static native @Cast("bool") boolean Serialize(@Cast("FILE*") Pointer fp, @Const int[] data);
// Targeting ../TFile.java



  // namespace tesseract.

// #endif


// Parsed from tesseract/strngs.h

/**********************************************************************
 * File:        strngs.h  (Formerly strings.h)
 * Description: STRING class definition.
 * Author:      Ray Smith
 *
 * (C) Copyright 1991, Hewlett-Packard Ltd.
 ** Licensed under the Apache License, Version 2.0 (the "License");
 ** you may not use this file except in compliance with the License.
 ** You may obtain a copy of the License at
 ** http://www.apache.org/licenses/LICENSE-2.0
 ** Unless required by applicable law or agreed to in writing, software
 ** distributed under the License is distributed on an "AS IS" BASIS,
 ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ** See the License for the specific language governing permissions and
 ** limitations under the License.
 *
 **********************************************************************/

// #ifndef STRNGS_H
// #define STRNGS_H

// #include <cassert>     // for assert
// #include <cstdint>     // for uint32_t
// #include <cstdio>      // for FILE
// #include <cstring>     // for strncpy
// #include "platform.h"  // for TESS_API
  // namespace tesseract.

// STRING_IS_PROTECTED means that  string[index] = X is invalid
// because you have to go through strings interface to modify it.
// This allows the string to ensure internal integrity and maintain
// its own string length. Unfortunately this is not possible because
// STRINGS are used as direct-manipulation data buffers for things
// like length arrays and many places cast away the const on string()
// to mutate the string. Turning this off means that internally we
// cannot assume we know the strlen.
public static native @MemberGetter int STRING_IS_PROTECTED();
public static final int STRING_IS_PROTECTED = STRING_IS_PROTECTED();
// Targeting ../STRING.java



// #endif


// Parsed from tesseract/genericvector.h

///////////////////////////////////////////////////////////////////////
// File:        genericvector.h
// Description: Generic vector class
// Author:      Daria Antonova
//
// (C) Copyright 2007, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////
//
// #ifndef TESSERACT_CCUTIL_GENERICVECTOR_H_
// #define TESSERACT_CCUTIL_GENERICVECTOR_H_

// #include <algorithm>
// #include <cassert>
// #include <climits>      // for LONG_MAX
// #include <cstdint>      // for uint32_t
// #include <cstdio>
// #include <cstdlib>

// #include "helpers.h"
// #include "serialis.h"
// #include "strngs.h"
// #include "tesscallback.h"
// Targeting ../CharGenericVector.java


// Targeting ../StringGenericVector.java


// Targeting ../IntGenericVector.java



// The default FileReader loads the whole file into the vector of char,
// returning false on error.
@Namespace("tesseract") public static native @Cast("bool") boolean LoadDataFromFile(@Cast("const char*") BytePointer filename, CharGenericVector data);
@Namespace("tesseract") public static native @Cast("bool") boolean LoadDataFromFile(String filename, CharGenericVector data);

@Namespace("tesseract") public static native @Cast("bool") boolean LoadDataFromFile(@Const @ByRef STRING filename,
                             CharGenericVector data);

// The default FileWriter writes the vector of char to the filename file,
// returning false on error.
@Namespace("tesseract") public static native @Cast("bool") boolean SaveDataToFile(@Const @ByRef CharGenericVector data,
                           @Const @ByRef STRING filename);

// Used by sort()
// return < 0 if t1 < t2
// return 0 if t1 == t2
// return > 0 if t1 > t2

// Used by PointerVector::sort()
// return < 0 if t1 < t2
// return 0 if t1 == t2
// return > 0 if t1 > t2

// Subclass for a vector of pointers. Use in preference to GenericVector<T*>
// as it provides automatic deletion and correct serialization, with the
// corollary that all copy operations are deep copies of the pointed-to objects.


// Targeting ../IntGenericVectorEqEq.java







// Reserve some memory. If the internal array contains elements, they are
// copied.




// Resizes to size and sets all values to t.


// Return the object from an index.





// Returns the last object and removes it.


// Return the object from an index.


// Shifts the rest of the elements to the right to make
// space for the new elements and inserts the given element
// at the specified index.


// Removes an element at the given index and
// shifts the remaining elements to the left.


// Return true if the index is valindex


// Return the index of the T object.


// Return true if T is in the array


// Add an element in the array




// Add an element in the array (front)








// Clear the array, calling the callback function if any.








// Writes a vector of simple types to the given file. Assumes that bitwise
// read/write of T will work. Returns false in case of error.



// Reads a vector of simple types from the given file. Assumes that bitwise
// read/write will work with ReverseN according to sizeof(T).
// Returns false in case of error.
// If swap is true, assumes a big/little-endian swap is needed.




// Writes a vector of classes to the given file. Assumes the existence of
// bool T::Serialize(FILE* fp) const that returns false in case of error.
// Returns false in case of error.



// Reads a vector of classes from the given file. Assumes the existence of
// bool T::Deserialize(bool swap, FILE* fp) that returns false in case of
// error. Also needs T::T() and T::T(constT&), as init_to_size is used in
// this function. Returns false in case of error.
// If swap is true, assumes a big/little-endian swap is needed.




// This method clear the current object, then, does a shallow copy of
// its argument, and finally invalidates its argument.




// Internal recursive version of choose_nth_item.
// The algorithm used comes from "Algorithms" by Sedgewick:
// http://books.google.com/books/about/Algorithms.html?id=idUdqdDXqnAC
// The principle is to choose a random pivot, and move everything less than
// the pivot to its left, and everything greater than the pivot to the end
// of the array, then recurse on the part that contains the desired index, or
// just return the answer if it is in the equal section in the middle.
// The random pivot guarantees average linear time for the same reason that
// n times vector::push_back takes linear time on average.
// target_index, start and and end are all indices into the full array.
// Seed is a seed for rand_r for thread safety purposes. Its value is
// unimportant as the random numbers do not affect the result except
// between equal answers.


// #endif  // TESSERACT_CCUTIL_GENERICVECTOR_H_


// Parsed from tesseract/baseapi.h

///////////////////////////////////////////////////////////////////////
// File:        baseapi.h
// Description: Simple API for calling tesseract.
// Author:      Ray Smith
//
// (C) Copyright 2006, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef TESSERACT_API_BASEAPI_H_
// #define TESSERACT_API_BASEAPI_H_

// #include <cstdio>
// To avoid collision with other typenames include the ABSOLUTE MINIMUM
// complexity of includes here. Use forward declarations wherever possible
// and hide includes of complex types in baseapi.cpp.
// #include "apitypes.h"
// #include "pageiterator.h"
// #include "platform.h"
// #include "publictypes.h"
// #include "resultiterator.h"
// #include "serialis.h"
// #include "tess_version.h"
// #include "tesscallback.h"
// #include "thresholder.h"
// #include "unichar.h"
// Targeting ../ParagraphModel.java


// Targeting ../BLOCK_LIST.java


// Targeting ../DENORM.java


// Targeting ../MATRIX.java


// Targeting ../ROW.java


// Targeting ../ETEXT_DESC.java


// Targeting ../OSResults.java


// Targeting ../TBOX.java


// Targeting ../UNICHARSET.java


// Targeting ../WERD_CHOICE_LIST.java


// Targeting ../INT_FEATURE_STRUCT.java


// Targeting ../TBLOB.java


// Targeting ../Dawg.java


// Targeting ../Dict.java


// Targeting ../EquationDetect.java


// Targeting ../MutableIterator.java


// Targeting ../TessResultRenderer.java


// Targeting ../Trie.java


// Targeting ../Wordrec.java


// Targeting ../DictFunc.java


// Targeting ../ProbabilityInContextFunc.java


// Targeting ../ParamsModelClassifyFunc.java


// Targeting ../FillLatticeFunc.java


// Targeting ../TessBaseAPI.java

  // class TessBaseAPI.

/** Escape a char string - remove &<>"' with HTML codes. */
@Namespace("tesseract") public static native @ByVal STRING HOcrEscape(@Cast("const char*") BytePointer text);
@Namespace("tesseract") public static native @ByVal STRING HOcrEscape(String text);
  // namespace tesseract.

// #endif  // TESSERACT_API_BASEAPI_H_


// Parsed from tesseract/capi.h

///////////////////////////////////////////////////////////////////////
// File:        capi.h
// Description: C-API TessBaseAPI
//
// (C) Copyright 2012, Google Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////

// #ifndef API_CAPI_H_
// #define API_CAPI_H_

// #if defined(TESSERACT_API_BASEAPI_H_) && !defined(TESS_CAPI_INCLUDE_BASEAPI)
// #  define TESS_CAPI_INCLUDE_BASEAPI
// #endif

// #ifdef TESS_CAPI_INCLUDE_BASEAPI
// #  include "baseapi.h"
// #  include "ocrclass.h"
// #  include "pageiterator.h"
// #  include "renderer.h"
// #  include "resultiterator.h"
// #else
// #endif

// #ifdef __cplusplus
// #endif

// #ifndef TESS_CALL
// #  if defined(WIN32)
// #    define TESS_CALL __cdecl
// #  else
// #    define TESS_CALL
// #  endif
// #endif

// #ifndef BOOL
// #endif

// #ifdef TESS_CAPI_INCLUDE_BASEAPI
// typedef tesseract::ParamsModelClassifyFunc TessParamsModelClassifyFunc;
// Targeting ../TessCancelFunc.java


// Targeting ../TessProgressFunc.java



/* General free functions */

public static native @Cast("const char*") BytePointer TessVersion();
public static native void TessDeleteText(@Cast("const char*") BytePointer text);
public static native void TessDeleteText(String text);
public static native void TessDeleteTextArray(@Cast("char**") PointerPointer arr);
public static native void TessDeleteTextArray(@Cast("char**") @ByPtrPtr BytePointer arr);
public static native void TessDeleteTextArray(@Cast("char**") @ByPtrPtr ByteBuffer arr);
public static native void TessDeleteTextArray(@Cast("char**") @ByPtrPtr byte[] arr);
public static native void TessDeleteIntArray(@Const IntPointer arr);
public static native void TessDeleteIntArray(@Const IntBuffer arr);
public static native void TessDeleteIntArray(@Const int[] arr);

/* Renderer API */
public static native TessResultRenderer TessTextRendererCreate(@Cast("const char*") BytePointer outputbase);
public static native TessResultRenderer TessTextRendererCreate(String outputbase);
public static native TessResultRenderer TessHOcrRendererCreate(@Cast("const char*") BytePointer outputbase);
public static native TessResultRenderer TessHOcrRendererCreate(String outputbase);
public static native TessResultRenderer TessHOcrRendererCreate2(@Cast("const char*") BytePointer outputbase, @Cast("BOOL") boolean font_info);
public static native TessResultRenderer TessHOcrRendererCreate2(String outputbase, @Cast("BOOL") boolean font_info);
public static native TessResultRenderer TessAltoRendererCreate(@Cast("const char*") BytePointer outputbase);
public static native TessResultRenderer TessAltoRendererCreate(String outputbase);
public static native TessResultRenderer TessTsvRendererCreate(@Cast("const char*") BytePointer outputbase);
public static native TessResultRenderer TessTsvRendererCreate(String outputbase);
public static native TessResultRenderer TessPDFRendererCreate(
    @Cast("const char*") BytePointer outputbase, @Cast("const char*") BytePointer datadir, @Cast("BOOL") boolean textonly);
public static native TessResultRenderer TessPDFRendererCreate(
    String outputbase, String datadir, @Cast("BOOL") boolean textonly);
public static native TessResultRenderer TessUnlvRendererCreate(@Cast("const char*") BytePointer outputbase);
public static native TessResultRenderer TessUnlvRendererCreate(String outputbase);
public static native TessResultRenderer TessBoxTextRendererCreate(@Cast("const char*") BytePointer outputbase);
public static native TessResultRenderer TessBoxTextRendererCreate(String outputbase);
public static native TessResultRenderer TessLSTMBoxRendererCreate(@Cast("const char*") BytePointer outputbase);
public static native TessResultRenderer TessLSTMBoxRendererCreate(String outputbase);
public static native TessResultRenderer TessWordStrBoxRendererCreate(@Cast("const char*") BytePointer outputbase);
public static native TessResultRenderer TessWordStrBoxRendererCreate(String outputbase);

public static native void TessDeleteResultRenderer(TessResultRenderer renderer);
public static native void TessResultRendererInsert(TessResultRenderer renderer,
                                                 TessResultRenderer next);
public static native TessResultRenderer TessResultRendererNext(TessResultRenderer renderer);
public static native @Cast("BOOL") boolean TessResultRendererBeginDocument(
    TessResultRenderer renderer, @Cast("const char*") BytePointer title);
public static native @Cast("BOOL") boolean TessResultRendererBeginDocument(
    TessResultRenderer renderer, String title);
public static native @Cast("BOOL") boolean TessResultRendererAddImage(TessResultRenderer renderer,
                                                   TessBaseAPI api);
public static native @Cast("BOOL") boolean TessResultRendererEndDocument(TessResultRenderer renderer);

public static native @Cast("const char*") BytePointer TessResultRendererExtention(TessResultRenderer renderer);
public static native @Cast("const char*") BytePointer TessResultRendererTitle(TessResultRenderer renderer);
public static native int TessResultRendererImageNum(TessResultRenderer renderer);

/* Base API */

public static native TessBaseAPI TessBaseAPICreate();
public static native void TessBaseAPIDelete(TessBaseAPI handle);

public static native @Cast("size_t") long TessBaseAPIGetOpenCLDevice(TessBaseAPI handle,
                                                     @Cast("void**") PointerPointer device);
public static native @Cast("size_t") long TessBaseAPIGetOpenCLDevice(TessBaseAPI handle,
                                                     @Cast("void**") @ByPtrPtr Pointer device);

public static native void TessBaseAPISetInputName(TessBaseAPI handle,
                                                @Cast("const char*") BytePointer name);
public static native void TessBaseAPISetInputName(TessBaseAPI handle,
                                                String name);
public static native @Cast("const char*") BytePointer TessBaseAPIGetInputName(TessBaseAPI handle);

public static native void TessBaseAPISetInputImage(TessBaseAPI handle,
                                                 PIX pix);
public static native PIX TessBaseAPIGetInputImage(TessBaseAPI handle);

public static native int TessBaseAPIGetSourceYResolution(TessBaseAPI handle);
public static native @Cast("const char*") BytePointer TessBaseAPIGetDatapath(TessBaseAPI handle);

public static native void TessBaseAPISetOutputName(TessBaseAPI handle,
                                                 @Cast("const char*") BytePointer name);
public static native void TessBaseAPISetOutputName(TessBaseAPI handle,
                                                 String name);

public static native @Cast("BOOL") boolean TessBaseAPISetVariable(TessBaseAPI handle,
                                               @Cast("const char*") BytePointer name,
                                               @Cast("const char*") BytePointer value);
public static native @Cast("BOOL") boolean TessBaseAPISetVariable(TessBaseAPI handle,
                                               String name,
                                               String value);
public static native @Cast("BOOL") boolean TessBaseAPISetDebugVariable(TessBaseAPI handle,
                                                    @Cast("const char*") BytePointer name,
                                                    @Cast("const char*") BytePointer value);
public static native @Cast("BOOL") boolean TessBaseAPISetDebugVariable(TessBaseAPI handle,
                                                    String name,
                                                    String value);

public static native @Cast("BOOL") boolean TessBaseAPIGetIntVariable(@Const TessBaseAPI handle,
                                                  @Cast("const char*") BytePointer name, IntPointer value);
public static native @Cast("BOOL") boolean TessBaseAPIGetIntVariable(@Const TessBaseAPI handle,
                                                  String name, IntBuffer value);
public static native @Cast("BOOL") boolean TessBaseAPIGetIntVariable(@Const TessBaseAPI handle,
                                                  @Cast("const char*") BytePointer name, int[] value);
public static native @Cast("BOOL") boolean TessBaseAPIGetIntVariable(@Const TessBaseAPI handle,
                                                  String name, IntPointer value);
public static native @Cast("BOOL") boolean TessBaseAPIGetIntVariable(@Const TessBaseAPI handle,
                                                  @Cast("const char*") BytePointer name, IntBuffer value);
public static native @Cast("BOOL") boolean TessBaseAPIGetIntVariable(@Const TessBaseAPI handle,
                                                  String name, int[] value);
public static native @Cast("BOOL") boolean TessBaseAPIGetBoolVariable(@Const TessBaseAPI handle,
                                                   @Cast("const char*") BytePointer name,
                                                   @Cast("BOOL*") BoolPointer value);
public static native @Cast("BOOL") boolean TessBaseAPIGetBoolVariable(@Const TessBaseAPI handle,
                                                   String name,
                                                   @Cast("BOOL*") BoolPointer value);
public static native @Cast("BOOL") boolean TessBaseAPIGetDoubleVariable(@Const TessBaseAPI handle,
                                                     @Cast("const char*") BytePointer name,
                                                     DoublePointer value);
public static native @Cast("BOOL") boolean TessBaseAPIGetDoubleVariable(@Const TessBaseAPI handle,
                                                     String name,
                                                     DoubleBuffer value);
public static native @Cast("BOOL") boolean TessBaseAPIGetDoubleVariable(@Const TessBaseAPI handle,
                                                     @Cast("const char*") BytePointer name,
                                                     double[] value);
public static native @Cast("BOOL") boolean TessBaseAPIGetDoubleVariable(@Const TessBaseAPI handle,
                                                     String name,
                                                     DoublePointer value);
public static native @Cast("BOOL") boolean TessBaseAPIGetDoubleVariable(@Const TessBaseAPI handle,
                                                     @Cast("const char*") BytePointer name,
                                                     DoubleBuffer value);
public static native @Cast("BOOL") boolean TessBaseAPIGetDoubleVariable(@Const TessBaseAPI handle,
                                                     String name,
                                                     double[] value);
public static native @Cast("const char*") BytePointer TessBaseAPIGetStringVariable(@Const TessBaseAPI handle, @Cast("const char*") BytePointer name);
public static native String TessBaseAPIGetStringVariable(@Const TessBaseAPI handle, String name);

public static native void TessBaseAPIPrintVariables(@Const TessBaseAPI handle,
                                                  @Cast("FILE*") Pointer fp);
public static native @Cast("BOOL") boolean TessBaseAPIPrintVariablesToFile(
    @Const TessBaseAPI handle, @Cast("const char*") BytePointer filename);
public static native @Cast("BOOL") boolean TessBaseAPIPrintVariablesToFile(
    @Const TessBaseAPI handle, String filename);

// #ifdef TESS_CAPI_INCLUDE_BASEAPI

public static native @Cast("BOOL") boolean TessBaseAPIGetVariableAsString(TessBaseAPI handle,
                                                       @Cast("const char*") BytePointer name,
                                                       STRING val);
public static native @Cast("BOOL") boolean TessBaseAPIGetVariableAsString(TessBaseAPI handle,
                                                       String name,
                                                       STRING val);



// #endif  // def TESS_CAPI_INCLUDE_BASEAPI

public static native int TessBaseAPIInit1(TessBaseAPI handle,
                                        @Cast("const char*") BytePointer datapath,
                                        @Cast("const char*") BytePointer language,
                                        @Cast("TessOcrEngineMode") int oem, @Cast("char**") PointerPointer configs,
                                        int configs_size);
public static native int TessBaseAPIInit1(TessBaseAPI handle,
                                        @Cast("const char*") BytePointer datapath,
                                        @Cast("const char*") BytePointer language,
                                        @Cast("TessOcrEngineMode") int oem, @Cast("char**") @ByPtrPtr BytePointer configs,
                                        int configs_size);
public static native int TessBaseAPIInit1(TessBaseAPI handle,
                                        String datapath,
                                        String language,
                                        @Cast("TessOcrEngineMode") int oem, @Cast("char**") @ByPtrPtr ByteBuffer configs,
                                        int configs_size);
public static native int TessBaseAPIInit1(TessBaseAPI handle,
                                        @Cast("const char*") BytePointer datapath,
                                        @Cast("const char*") BytePointer language,
                                        @Cast("TessOcrEngineMode") int oem, @Cast("char**") @ByPtrPtr byte[] configs,
                                        int configs_size);
public static native int TessBaseAPIInit1(TessBaseAPI handle,
                                        String datapath,
                                        String language,
                                        @Cast("TessOcrEngineMode") int oem, @Cast("char**") @ByPtrPtr BytePointer configs,
                                        int configs_size);
public static native int TessBaseAPIInit1(TessBaseAPI handle,
                                        @Cast("const char*") BytePointer datapath,
                                        @Cast("const char*") BytePointer language,
                                        @Cast("TessOcrEngineMode") int oem, @Cast("char**") @ByPtrPtr ByteBuffer configs,
                                        int configs_size);
public static native int TessBaseAPIInit1(TessBaseAPI handle,
                                        String datapath,
                                        String language,
                                        @Cast("TessOcrEngineMode") int oem, @Cast("char**") @ByPtrPtr byte[] configs,
                                        int configs_size);
public static native int TessBaseAPIInit2(TessBaseAPI handle,
                                        @Cast("const char*") BytePointer datapath,
                                        @Cast("const char*") BytePointer language,
                                        @Cast("TessOcrEngineMode") int oem);
public static native int TessBaseAPIInit2(TessBaseAPI handle,
                                        String datapath,
                                        String language,
                                        @Cast("TessOcrEngineMode") int oem);
public static native int TessBaseAPIInit3(TessBaseAPI handle,
                                        @Cast("const char*") BytePointer datapath,
                                        @Cast("const char*") BytePointer language);
public static native int TessBaseAPIInit3(TessBaseAPI handle,
                                        String datapath,
                                        String language);

public static native int TessBaseAPIInit4(
    TessBaseAPI handle, @Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language,
    @Cast("TessOcrEngineMode") int mode, @Cast("char**") PointerPointer configs, int configs_size, @Cast("char**") PointerPointer vars_vec,
    @Cast("char**") PointerPointer vars_values, @Cast("size_t") long vars_vec_size, @Cast("BOOL") boolean set_only_non_debug_params);
public static native int TessBaseAPIInit4(
    TessBaseAPI handle, @Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language,
    @Cast("TessOcrEngineMode") int mode, @Cast("char**") @ByPtrPtr BytePointer configs, int configs_size, @Cast("char**") @ByPtrPtr BytePointer vars_vec,
    @Cast("char**") @ByPtrPtr BytePointer vars_values, @Cast("size_t") long vars_vec_size, @Cast("BOOL") boolean set_only_non_debug_params);
public static native int TessBaseAPIInit4(
    TessBaseAPI handle, String datapath, String language,
    @Cast("TessOcrEngineMode") int mode, @Cast("char**") @ByPtrPtr ByteBuffer configs, int configs_size, @Cast("char**") @ByPtrPtr ByteBuffer vars_vec,
    @Cast("char**") @ByPtrPtr ByteBuffer vars_values, @Cast("size_t") long vars_vec_size, @Cast("BOOL") boolean set_only_non_debug_params);
public static native int TessBaseAPIInit4(
    TessBaseAPI handle, @Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language,
    @Cast("TessOcrEngineMode") int mode, @Cast("char**") @ByPtrPtr byte[] configs, int configs_size, @Cast("char**") @ByPtrPtr byte[] vars_vec,
    @Cast("char**") @ByPtrPtr byte[] vars_values, @Cast("size_t") long vars_vec_size, @Cast("BOOL") boolean set_only_non_debug_params);
public static native int TessBaseAPIInit4(
    TessBaseAPI handle, String datapath, String language,
    @Cast("TessOcrEngineMode") int mode, @Cast("char**") @ByPtrPtr BytePointer configs, int configs_size, @Cast("char**") @ByPtrPtr BytePointer vars_vec,
    @Cast("char**") @ByPtrPtr BytePointer vars_values, @Cast("size_t") long vars_vec_size, @Cast("BOOL") boolean set_only_non_debug_params);
public static native int TessBaseAPIInit4(
    TessBaseAPI handle, @Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language,
    @Cast("TessOcrEngineMode") int mode, @Cast("char**") @ByPtrPtr ByteBuffer configs, int configs_size, @Cast("char**") @ByPtrPtr ByteBuffer vars_vec,
    @Cast("char**") @ByPtrPtr ByteBuffer vars_values, @Cast("size_t") long vars_vec_size, @Cast("BOOL") boolean set_only_non_debug_params);
public static native int TessBaseAPIInit4(
    TessBaseAPI handle, String datapath, String language,
    @Cast("TessOcrEngineMode") int mode, @Cast("char**") @ByPtrPtr byte[] configs, int configs_size, @Cast("char**") @ByPtrPtr byte[] vars_vec,
    @Cast("char**") @ByPtrPtr byte[] vars_values, @Cast("size_t") long vars_vec_size, @Cast("BOOL") boolean set_only_non_debug_params);

public static native @Cast("const char*") BytePointer TessBaseAPIGetInitLanguagesAsString(@Const TessBaseAPI handle);
public static native @Cast("char**") PointerPointer TessBaseAPIGetLoadedLanguagesAsVector(@Const TessBaseAPI handle);
public static native @Cast("char**") PointerPointer TessBaseAPIGetAvailableLanguagesAsVector(@Const TessBaseAPI handle);

public static native int TessBaseAPIInitLangMod(TessBaseAPI handle,
                                              @Cast("const char*") BytePointer datapath,
                                              @Cast("const char*") BytePointer language);
public static native int TessBaseAPIInitLangMod(TessBaseAPI handle,
                                              String datapath,
                                              String language);
public static native void TessBaseAPIInitForAnalysePage(TessBaseAPI handle);

public static native void TessBaseAPIReadConfigFile(TessBaseAPI handle,
                                                  @Cast("const char*") BytePointer filename);
public static native void TessBaseAPIReadConfigFile(TessBaseAPI handle,
                                                  String filename);
public static native void TessBaseAPIReadDebugConfigFile(TessBaseAPI handle,
                                                       @Cast("const char*") BytePointer filename);
public static native void TessBaseAPIReadDebugConfigFile(TessBaseAPI handle,
                                                       String filename);

public static native void TessBaseAPISetPageSegMode(TessBaseAPI handle,
                                                  @Cast("TessPageSegMode") int mode);
public static native @Cast("TessPageSegMode") int TessBaseAPIGetPageSegMode(@Const TessBaseAPI handle);

public static native @Cast("char*") BytePointer TessBaseAPIRect(TessBaseAPI handle,
                                         @Cast("const unsigned char*") BytePointer imagedata,
                                         int bytes_per_pixel,
                                         int bytes_per_line, int left, int top,
                                         int width, int height);
public static native @Cast("char*") ByteBuffer TessBaseAPIRect(TessBaseAPI handle,
                                         @Cast("const unsigned char*") ByteBuffer imagedata,
                                         int bytes_per_pixel,
                                         int bytes_per_line, int left, int top,
                                         int width, int height);
public static native @Cast("char*") byte[] TessBaseAPIRect(TessBaseAPI handle,
                                         @Cast("const unsigned char*") byte[] imagedata,
                                         int bytes_per_pixel,
                                         int bytes_per_line, int left, int top,
                                         int width, int height);

public static native void TessBaseAPIClearAdaptiveClassifier(TessBaseAPI handle);

public static native void TessBaseAPISetImage(TessBaseAPI handle,
                                            @Cast("const unsigned char*") BytePointer imagedata,
                                            int width, int height,
                                            int bytes_per_pixel,
                                            int bytes_per_line);
public static native void TessBaseAPISetImage(TessBaseAPI handle,
                                            @Cast("const unsigned char*") ByteBuffer imagedata,
                                            int width, int height,
                                            int bytes_per_pixel,
                                            int bytes_per_line);
public static native void TessBaseAPISetImage(TessBaseAPI handle,
                                            @Cast("const unsigned char*") byte[] imagedata,
                                            int width, int height,
                                            int bytes_per_pixel,
                                            int bytes_per_line);
public static native void TessBaseAPISetImage2(TessBaseAPI handle,
                                             PIX pix);

public static native void TessBaseAPISetSourceResolution(TessBaseAPI handle,
                                                       int ppi);

public static native void TessBaseAPISetRectangle(TessBaseAPI handle, int left,
                                                int top, int width, int height);

// #ifdef TESS_CAPI_INCLUDE_BASEAPI
public static native void TessBaseAPISetThresholder(
    TessBaseAPI handle, @Cast("TessImageThresholder*") ImageThresholder thresholder);
// #endif

public static native PIX TessBaseAPIGetThresholdedImage(TessBaseAPI handle);
public static native BOXA TessBaseAPIGetRegions(TessBaseAPI handle,
                                                      @Cast("Pixa**") PointerPointer pixa);
public static native BOXA TessBaseAPIGetRegions(TessBaseAPI handle,
                                                      @ByPtrPtr PIXA pixa);
public static native BOXA TessBaseAPIGetTextlines(TessBaseAPI handle,
                                                        @Cast("Pixa**") PointerPointer pixa,
                                                        @Cast("int**") PointerPointer blockids);
public static native BOXA TessBaseAPIGetTextlines(TessBaseAPI handle,
                                                        @ByPtrPtr PIXA pixa,
                                                        @ByPtrPtr IntPointer blockids);
public static native BOXA TessBaseAPIGetTextlines(TessBaseAPI handle,
                                                        @ByPtrPtr PIXA pixa,
                                                        @ByPtrPtr IntBuffer blockids);
public static native BOXA TessBaseAPIGetTextlines(TessBaseAPI handle,
                                                        @ByPtrPtr PIXA pixa,
                                                        @ByPtrPtr int[] blockids);
public static native BOXA TessBaseAPIGetTextlines1(TessBaseAPI handle, @Cast("BOOL") boolean raw_image, int raw_padding,
                         @Cast("Pixa**") PointerPointer pixa, @Cast("int**") PointerPointer blockids, @Cast("int**") PointerPointer paraids);
public static native BOXA TessBaseAPIGetTextlines1(TessBaseAPI handle, @Cast("BOOL") boolean raw_image, int raw_padding,
                         @ByPtrPtr PIXA pixa, @ByPtrPtr IntPointer blockids, @ByPtrPtr IntPointer paraids);
public static native BOXA TessBaseAPIGetTextlines1(TessBaseAPI handle, @Cast("BOOL") boolean raw_image, int raw_padding,
                         @ByPtrPtr PIXA pixa, @ByPtrPtr IntBuffer blockids, @ByPtrPtr IntBuffer paraids);
public static native BOXA TessBaseAPIGetTextlines1(TessBaseAPI handle, @Cast("BOOL") boolean raw_image, int raw_padding,
                         @ByPtrPtr PIXA pixa, @ByPtrPtr int[] blockids, @ByPtrPtr int[] paraids);
public static native BOXA TessBaseAPIGetStrips(TessBaseAPI handle,
                                                     @Cast("Pixa**") PointerPointer pixa,
                                                     @Cast("int**") PointerPointer blockids);
public static native BOXA TessBaseAPIGetStrips(TessBaseAPI handle,
                                                     @ByPtrPtr PIXA pixa,
                                                     @ByPtrPtr IntPointer blockids);
public static native BOXA TessBaseAPIGetStrips(TessBaseAPI handle,
                                                     @ByPtrPtr PIXA pixa,
                                                     @ByPtrPtr IntBuffer blockids);
public static native BOXA TessBaseAPIGetStrips(TessBaseAPI handle,
                                                     @ByPtrPtr PIXA pixa,
                                                     @ByPtrPtr int[] blockids);
public static native BOXA TessBaseAPIGetWords(TessBaseAPI handle,
                                                    @Cast("Pixa**") PointerPointer pixa);
public static native BOXA TessBaseAPIGetWords(TessBaseAPI handle,
                                                    @ByPtrPtr PIXA pixa);
public static native BOXA TessBaseAPIGetConnectedComponents(TessBaseAPI handle, @Cast("Pixa**") PointerPointer cc);
public static native BOXA TessBaseAPIGetConnectedComponents(TessBaseAPI handle, @ByPtrPtr PIXA cc);
public static native BOXA TessBaseAPIGetComponentImages(
    TessBaseAPI handle, @Cast("TessPageIteratorLevel") int level, @Cast("BOOL") boolean text_only,
    @Cast("Pixa**") PointerPointer pixa, @Cast("int**") PointerPointer blockids);
public static native BOXA TessBaseAPIGetComponentImages(
    TessBaseAPI handle, @Cast("TessPageIteratorLevel") int level, @Cast("BOOL") boolean text_only,
    @ByPtrPtr PIXA pixa, @ByPtrPtr IntPointer blockids);
public static native BOXA TessBaseAPIGetComponentImages(
    TessBaseAPI handle, @Cast("TessPageIteratorLevel") int level, @Cast("BOOL") boolean text_only,
    @ByPtrPtr PIXA pixa, @ByPtrPtr IntBuffer blockids);
public static native BOXA TessBaseAPIGetComponentImages(
    TessBaseAPI handle, @Cast("TessPageIteratorLevel") int level, @Cast("BOOL") boolean text_only,
    @ByPtrPtr PIXA pixa, @ByPtrPtr int[] blockids);
public static native BOXA TessBaseAPIGetComponentImages1(
    TessBaseAPI handle, @Cast("TessPageIteratorLevel") int level, @Cast("BOOL") boolean text_only,
    @Cast("BOOL") boolean raw_image, int raw_padding, @Cast("Pixa**") PointerPointer pixa, @Cast("int**") PointerPointer blockids,
    @Cast("int**") PointerPointer paraids);
public static native BOXA TessBaseAPIGetComponentImages1(
    TessBaseAPI handle, @Cast("TessPageIteratorLevel") int level, @Cast("BOOL") boolean text_only,
    @Cast("BOOL") boolean raw_image, int raw_padding, @ByPtrPtr PIXA pixa, @ByPtrPtr IntPointer blockids,
    @ByPtrPtr IntPointer paraids);
public static native BOXA TessBaseAPIGetComponentImages1(
    TessBaseAPI handle, @Cast("TessPageIteratorLevel") int level, @Cast("BOOL") boolean text_only,
    @Cast("BOOL") boolean raw_image, int raw_padding, @ByPtrPtr PIXA pixa, @ByPtrPtr IntBuffer blockids,
    @ByPtrPtr IntBuffer paraids);
public static native BOXA TessBaseAPIGetComponentImages1(
    TessBaseAPI handle, @Cast("TessPageIteratorLevel") int level, @Cast("BOOL") boolean text_only,
    @Cast("BOOL") boolean raw_image, int raw_padding, @ByPtrPtr PIXA pixa, @ByPtrPtr int[] blockids,
    @ByPtrPtr int[] paraids);

public static native int TessBaseAPIGetThresholdedImageScaleFactor(@Const TessBaseAPI handle);

public static native @Cast("TessPageIterator*") PageIterator TessBaseAPIAnalyseLayout(TessBaseAPI handle);

public static native int TessBaseAPIRecognize(TessBaseAPI handle,
                                            ETEXT_DESC monitor);

// #ifndef DISABLED_LEGACY_ENGINE
public static native int TessBaseAPIRecognizeForChopTest(TessBaseAPI handle,
                                                       ETEXT_DESC monitor);
// #endif

public static native @Cast("BOOL") boolean TessBaseAPIProcessPages(TessBaseAPI handle,
                                                @Cast("const char*") BytePointer filename,
                                                @Cast("const char*") BytePointer retry_config,
                                                int timeout_millisec,
                                                TessResultRenderer renderer);
public static native @Cast("BOOL") boolean TessBaseAPIProcessPages(TessBaseAPI handle,
                                                String filename,
                                                String retry_config,
                                                int timeout_millisec,
                                                TessResultRenderer renderer);
public static native @Cast("BOOL") boolean TessBaseAPIProcessPage(TessBaseAPI handle,
                                               PIX pix, int page_index,
                                               @Cast("const char*") BytePointer filename,
                                               @Cast("const char*") BytePointer retry_config,
                                               int timeout_millisec,
                                               TessResultRenderer renderer);
public static native @Cast("BOOL") boolean TessBaseAPIProcessPage(TessBaseAPI handle,
                                               PIX pix, int page_index,
                                               String filename,
                                               String retry_config,
                                               int timeout_millisec,
                                               TessResultRenderer renderer);

public static native @Cast("TessResultIterator*") ResultIterator TessBaseAPIGetIterator(TessBaseAPI handle);
public static native @Cast("TessMutableIterator*") MutableIterator TessBaseAPIGetMutableIterator(TessBaseAPI handle);

public static native @Cast("char*") BytePointer TessBaseAPIGetUTF8Text(TessBaseAPI handle);
public static native @Cast("char*") BytePointer TessBaseAPIGetHOCRText(TessBaseAPI handle,
                                                int page_number);

public static native @Cast("char*") BytePointer TessBaseAPIGetAltoText(TessBaseAPI handle,
                                                int page_number);
public static native @Cast("char*") BytePointer TessBaseAPIGetTsvText(TessBaseAPI handle,
                                               int page_number);

public static native @Cast("char*") BytePointer TessBaseAPIGetBoxText(TessBaseAPI handle,
                                               int page_number);
public static native @Cast("char*") BytePointer TessBaseAPIGetLSTMBoxText(TessBaseAPI handle,
                                                   int page_number);
public static native @Cast("char*") BytePointer TessBaseAPIGetWordStrBoxText(TessBaseAPI handle,
                                                      int page_number);

public static native @Cast("char*") BytePointer TessBaseAPIGetUNLVText(TessBaseAPI handle);
public static native int TessBaseAPIMeanTextConf(TessBaseAPI handle);

public static native IntPointer TessBaseAPIAllWordConfidences(TessBaseAPI handle);

// #ifndef DISABLED_LEGACY_ENGINE
public static native @Cast("BOOL") boolean TessBaseAPIAdaptToWordStr(TessBaseAPI handle,
                                                  @Cast("TessPageSegMode") int mode,
                                                  @Cast("const char*") BytePointer wordstr);
public static native @Cast("BOOL") boolean TessBaseAPIAdaptToWordStr(TessBaseAPI handle,
                                                  @Cast("TessPageSegMode") int mode,
                                                  String wordstr);
// #endif  // ndef DISABLED_LEGACY_ENGINE

public static native void TessBaseAPIClear(TessBaseAPI handle);
public static native void TessBaseAPIEnd(TessBaseAPI handle);

public static native int TessBaseAPIIsValidWord(TessBaseAPI handle,
                                              @Cast("const char*") BytePointer word);
public static native int TessBaseAPIIsValidWord(TessBaseAPI handle,
                                              String word);
public static native @Cast("BOOL") boolean TessBaseAPIGetTextDirection(TessBaseAPI handle,
                                                    IntPointer out_offset,
                                                    FloatPointer out_slope);
public static native @Cast("BOOL") boolean TessBaseAPIGetTextDirection(TessBaseAPI handle,
                                                    IntBuffer out_offset,
                                                    FloatBuffer out_slope);
public static native @Cast("BOOL") boolean TessBaseAPIGetTextDirection(TessBaseAPI handle,
                                                    int[] out_offset,
                                                    float[] out_slope);

// #ifdef TESS_CAPI_INCLUDE_BASEAPI

public static native void TessBaseAPISetDictFunc(TessBaseAPI handle,
                                               @Cast("TessDictFunc") DictFunc f);

public static native void TessBaseAPIClearPersistentCache(TessBaseAPI handle);

public static native void TessBaseAPISetProbabilityInContextFunc(
    TessBaseAPI handle, @Cast("TessProbabilityInContextFunc") ProbabilityInContextFunc f);

// Call TessDeleteText(*best_script_name) to free memory allocated by this
// function
public static native @Cast("BOOL") boolean TessBaseAPIDetectOrientationScript(
    TessBaseAPI handle, IntPointer orient_deg, FloatPointer orient_conf,
    @Cast("const char**") PointerPointer script_name, FloatPointer script_conf);
public static native @Cast("BOOL") boolean TessBaseAPIDetectOrientationScript(
    TessBaseAPI handle, IntPointer orient_deg, FloatPointer orient_conf,
    @Cast("const char**") @ByPtrPtr BytePointer script_name, FloatPointer script_conf);
public static native @Cast("BOOL") boolean TessBaseAPIDetectOrientationScript(
    TessBaseAPI handle, IntBuffer orient_deg, FloatBuffer orient_conf,
    @Cast("const char**") @ByPtrPtr ByteBuffer script_name, FloatBuffer script_conf);
public static native @Cast("BOOL") boolean TessBaseAPIDetectOrientationScript(
    TessBaseAPI handle, int[] orient_deg, float[] orient_conf,
    @Cast("const char**") @ByPtrPtr byte[] script_name, float[] script_conf);

// #endif  // def TESS_CAPI_INCLUDE_BASEAPI

public static native @Cast("const char*") BytePointer TessBaseAPIGetUnichar(TessBaseAPI handle,
                                                     int unichar_id);

public static native void TessBaseAPISetMinOrientationMargin(TessBaseAPI handle,
                                                           double margin);

// #ifdef TESS_CAPI_INCLUDE_BASEAPI

public static native @Cast("const TessDawg*") Dawg TessBaseAPIGetDawg(@Const TessBaseAPI handle,
                                                      int i);

public static native int TessBaseAPINumDawgs(@Const TessBaseAPI handle);

public static native @Cast("TessOcrEngineMode") int TessBaseAPIOem(@Const TessBaseAPI handle);

public static native void TessBaseAPIInitTruthCallback(TessBaseAPI handle,
                                                     @Cast("TessTruthCallback*") TruthCallback4 cb);



// #endif

/* Page iterator */

public static native void TessPageIteratorDelete(@Cast("TessPageIterator*") PageIterator handle);

public static native @Cast("TessPageIterator*") PageIterator TessPageIteratorCopy(@Cast("const TessPageIterator*") PageIterator handle);

public static native void TessPageIteratorBegin(@Cast("TessPageIterator*") PageIterator handle);

public static native @Cast("BOOL") boolean TessPageIteratorNext(@Cast("TessPageIterator*") PageIterator handle,
                                             @Cast("TessPageIteratorLevel") int level);

public static native @Cast("BOOL") boolean TessPageIteratorIsAtBeginningOf(
    @Cast("const TessPageIterator*") PageIterator handle, @Cast("TessPageIteratorLevel") int level);

public static native @Cast("BOOL") boolean TessPageIteratorIsAtFinalElement(
    @Cast("const TessPageIterator*") PageIterator handle, @Cast("TessPageIteratorLevel") int level,
    @Cast("TessPageIteratorLevel") int element);

public static native @Cast("BOOL") boolean TessPageIteratorBoundingBox(
    @Cast("const TessPageIterator*") PageIterator handle, @Cast("TessPageIteratorLevel") int level, IntPointer left,
    IntPointer top, IntPointer right, IntPointer bottom);
public static native @Cast("BOOL") boolean TessPageIteratorBoundingBox(
    @Cast("const TessPageIterator*") PageIterator handle, @Cast("TessPageIteratorLevel") int level, IntBuffer left,
    IntBuffer top, IntBuffer right, IntBuffer bottom);
public static native @Cast("BOOL") boolean TessPageIteratorBoundingBox(
    @Cast("const TessPageIterator*") PageIterator handle, @Cast("TessPageIteratorLevel") int level, int[] left,
    int[] top, int[] right, int[] bottom);

public static native @Cast("TessPolyBlockType") int TessPageIteratorBlockType(@Cast("const TessPageIterator*") PageIterator handle);

public static native PIX TessPageIteratorGetBinaryImage(
    @Cast("const TessPageIterator*") PageIterator handle, @Cast("TessPageIteratorLevel") int level);

public static native PIX TessPageIteratorGetImage(
    @Cast("const TessPageIterator*") PageIterator handle, @Cast("TessPageIteratorLevel") int level, int padding,
    PIX original_image, IntPointer left, IntPointer top);
public static native PIX TessPageIteratorGetImage(
    @Cast("const TessPageIterator*") PageIterator handle, @Cast("TessPageIteratorLevel") int level, int padding,
    PIX original_image, IntBuffer left, IntBuffer top);
public static native PIX TessPageIteratorGetImage(
    @Cast("const TessPageIterator*") PageIterator handle, @Cast("TessPageIteratorLevel") int level, int padding,
    PIX original_image, int[] left, int[] top);

public static native @Cast("BOOL") boolean TessPageIteratorBaseline(@Cast("const TessPageIterator*") PageIterator handle,
                                                 @Cast("TessPageIteratorLevel") int level,
                                                 IntPointer x1, IntPointer y1, IntPointer x2,
                                                 IntPointer y2);
public static native @Cast("BOOL") boolean TessPageIteratorBaseline(@Cast("const TessPageIterator*") PageIterator handle,
                                                 @Cast("TessPageIteratorLevel") int level,
                                                 IntBuffer x1, IntBuffer y1, IntBuffer x2,
                                                 IntBuffer y2);
public static native @Cast("BOOL") boolean TessPageIteratorBaseline(@Cast("const TessPageIterator*") PageIterator handle,
                                                 @Cast("TessPageIteratorLevel") int level,
                                                 int[] x1, int[] y1, int[] x2,
                                                 int[] y2);

public static native void TessPageIteratorOrientation(
    @Cast("TessPageIterator*") PageIterator handle, @Cast("TessOrientation*") IntPointer orientation,
    @Cast("TessWritingDirection*") IntPointer writing_direction, @Cast("TessTextlineOrder*") IntPointer textline_order,
    FloatPointer deskew_angle);
public static native void TessPageIteratorOrientation(
    @Cast("TessPageIterator*") PageIterator handle, @Cast("TessOrientation*") IntBuffer orientation,
    @Cast("TessWritingDirection*") IntBuffer writing_direction, @Cast("TessTextlineOrder*") IntBuffer textline_order,
    FloatBuffer deskew_angle);
public static native void TessPageIteratorOrientation(
    @Cast("TessPageIterator*") PageIterator handle, @Cast("TessOrientation*") int[] orientation,
    @Cast("TessWritingDirection*") int[] writing_direction, @Cast("TessTextlineOrder*") int[] textline_order,
    float[] deskew_angle);

public static native void TessPageIteratorParagraphInfo(
    @Cast("TessPageIterator*") PageIterator handle, @Cast("TessParagraphJustification*") IntPointer justification,
    @Cast("BOOL*") BoolPointer is_list_item, @Cast("BOOL*") BoolPointer is_crown, IntPointer first_line_indent);
public static native void TessPageIteratorParagraphInfo(
    @Cast("TessPageIterator*") PageIterator handle, @Cast("TessParagraphJustification*") IntBuffer justification,
    @Cast("BOOL*") BoolPointer is_list_item, @Cast("BOOL*") BoolPointer is_crown, IntBuffer first_line_indent);
public static native void TessPageIteratorParagraphInfo(
    @Cast("TessPageIterator*") PageIterator handle, @Cast("TessParagraphJustification*") int[] justification,
    @Cast("BOOL*") BoolPointer is_list_item, @Cast("BOOL*") BoolPointer is_crown, int[] first_line_indent);

/* Result iterator */

public static native void TessResultIteratorDelete(@Cast("TessResultIterator*") ResultIterator handle);
public static native @Cast("TessResultIterator*") ResultIterator TessResultIteratorCopy(@Cast("const TessResultIterator*") ResultIterator handle);
public static native @Cast("TessPageIterator*") PageIterator TessResultIteratorGetPageIterator(@Cast("TessResultIterator*") ResultIterator handle);
public static native @Cast("const TessPageIterator*") PageIterator TessResultIteratorGetPageIteratorConst(@Cast("const TessResultIterator*") ResultIterator handle);
public static native @Cast("TessChoiceIterator*") ChoiceIterator TessResultIteratorGetChoiceIterator(@Cast("const TessResultIterator*") ResultIterator handle);

public static native @Cast("BOOL") boolean TessResultIteratorNext(@Cast("TessResultIterator*") ResultIterator handle,
                                               @Cast("TessPageIteratorLevel") int level);
public static native @Cast("char*") BytePointer TessResultIteratorGetUTF8Text(
    @Cast("const TessResultIterator*") ResultIterator handle, @Cast("TessPageIteratorLevel") int level);
public static native float TessResultIteratorConfidence(
    @Cast("const TessResultIterator*") ResultIterator handle, @Cast("TessPageIteratorLevel") int level);
public static native @Cast("const char*") BytePointer TessResultIteratorWordRecognitionLanguage(@Cast("const TessResultIterator*") ResultIterator handle);
public static native @Cast("const char*") BytePointer TessResultIteratorWordFontAttributes(
    @Cast("const TessResultIterator*") ResultIterator handle, @Cast("BOOL*") BoolPointer is_bold, @Cast("BOOL*") BoolPointer is_italic,
    @Cast("BOOL*") BoolPointer is_underlined, @Cast("BOOL*") BoolPointer is_monospace, @Cast("BOOL*") BoolPointer is_serif, @Cast("BOOL*") BoolPointer is_smallcaps,
    IntPointer pointsize, IntPointer font_id);
public static native String TessResultIteratorWordFontAttributes(
    @Cast("const TessResultIterator*") ResultIterator handle, @Cast("BOOL*") BoolPointer is_bold, @Cast("BOOL*") BoolPointer is_italic,
    @Cast("BOOL*") BoolPointer is_underlined, @Cast("BOOL*") BoolPointer is_monospace, @Cast("BOOL*") BoolPointer is_serif, @Cast("BOOL*") BoolPointer is_smallcaps,
    IntBuffer pointsize, IntBuffer font_id);
public static native @Cast("const char*") BytePointer TessResultIteratorWordFontAttributes(
    @Cast("const TessResultIterator*") ResultIterator handle, @Cast("BOOL*") BoolPointer is_bold, @Cast("BOOL*") BoolPointer is_italic,
    @Cast("BOOL*") BoolPointer is_underlined, @Cast("BOOL*") BoolPointer is_monospace, @Cast("BOOL*") BoolPointer is_serif, @Cast("BOOL*") BoolPointer is_smallcaps,
    int[] pointsize, int[] font_id);

public static native @Cast("BOOL") boolean TessResultIteratorWordIsFromDictionary(@Cast("const TessResultIterator*") ResultIterator handle);
public static native @Cast("BOOL") boolean TessResultIteratorWordIsNumeric(@Cast("const TessResultIterator*") ResultIterator handle);
public static native @Cast("BOOL") boolean TessResultIteratorSymbolIsSuperscript(@Cast("const TessResultIterator*") ResultIterator handle);
public static native @Cast("BOOL") boolean TessResultIteratorSymbolIsSubscript(@Cast("const TessResultIterator*") ResultIterator handle);
public static native @Cast("BOOL") boolean TessResultIteratorSymbolIsDropcap(@Cast("const TessResultIterator*") ResultIterator handle);

public static native void TessChoiceIteratorDelete(@Cast("TessChoiceIterator*") ChoiceIterator handle);
public static native @Cast("BOOL") boolean TessChoiceIteratorNext(@Cast("TessChoiceIterator*") ChoiceIterator handle);
public static native @Cast("const char*") BytePointer TessChoiceIteratorGetUTF8Text(@Cast("const TessChoiceIterator*") ChoiceIterator handle);
public static native float TessChoiceIteratorConfidence(@Cast("const TessChoiceIterator*") ChoiceIterator handle);

/* Progress monitor */

public static native ETEXT_DESC TessMonitorCreate();
public static native void TessMonitorDelete(ETEXT_DESC monitor);
public static native void TessMonitorSetCancelFunc(ETEXT_DESC monitor,
                                                 TessCancelFunc cancelFunc);
public static native void TessMonitorSetCancelThis(ETEXT_DESC monitor,
                                                 Pointer cancelThis);
public static native Pointer TessMonitorGetCancelThis(ETEXT_DESC monitor);
public static native void TessMonitorSetProgressFunc(ETEXT_DESC monitor, TessProgressFunc progressFunc);
public static native int TessMonitorGetProgress(ETEXT_DESC monitor);
public static native void TessMonitorSetDeadlineMSecs(ETEXT_DESC monitor,
                                                    int deadline);

// #ifndef DISABLED_LEGACY_ENGINE

// #  ifdef TESS_CAPI_INCLUDE_BASEAPI


public static native void TessBaseAPIGetFeaturesForBlob(
    TessBaseAPI handle, TBLOB blob, INT_FEATURE_STRUCT int_features,
    IntPointer num_features, IntPointer FeatureOutlineIndex);
public static native void TessBaseAPIGetFeaturesForBlob(
    TessBaseAPI handle, TBLOB blob, INT_FEATURE_STRUCT int_features,
    IntBuffer num_features, IntBuffer FeatureOutlineIndex);
public static native void TessBaseAPIGetFeaturesForBlob(
    TessBaseAPI handle, TBLOB blob, INT_FEATURE_STRUCT int_features,
    int[] num_features, int[] FeatureOutlineIndex);

public static native ROW TessFindRowForBox(BLOCK_LIST blocks, int left, int top,
                                          int right, int bottom);

public static native void TessBaseAPIRunAdaptiveClassifier(
    TessBaseAPI handle, TBLOB blob, int num_max_matches, IntPointer unichar_ids,
    FloatPointer ratings, IntPointer num_matches_returned);
public static native void TessBaseAPIRunAdaptiveClassifier(
    TessBaseAPI handle, TBLOB blob, int num_max_matches, IntBuffer unichar_ids,
    FloatBuffer ratings, IntBuffer num_matches_returned);
public static native void TessBaseAPIRunAdaptiveClassifier(
    TessBaseAPI handle, TBLOB blob, int num_max_matches, int[] unichar_ids,
    float[] ratings, int[] num_matches_returned);

public static native ROW TessMakeTessOCRRow(float baseline, float xheight,
                                           float descender, float ascender);

public static native TBLOB TessMakeTBLOB(PIX pix);

public static native void TessNormalizeTBLOB(TBLOB tblob, ROW row,
                                           @Cast("BOOL") boolean numeric_mode);

public static native BLOCK_LIST TessBaseAPIFindLinesCreateBlockList(TessBaseAPI handle);

public static native void TessDeleteBlockList(BLOCK_LIST block_list);

// #  endif  // def TESS_CAPI_INCLUDE_BASEAPI

// #endif  // ndef DISABLED_LEGACY_ENGINE

// #ifdef __cplusplus
// #endif

// #endif  // API_CAPI_H_


}
