/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.jboss.internal.HttpURLConnection;
import org.codehaus.cargo.container.jboss.internal.JdkHttpURLConnection;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;

public class JBossRemoteDeployer
extends AbstractRemoteDeployer {
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "";
    private String deployURL = "/jmx-console/HtmlAdaptor?action=invokeOpByName&name=jboss.system:service%3DMainDeployer&methodName=deploy&argType=java.net.URL&arg0=";
    private String undeployURL = "/jmx-console/HtmlAdaptor?action=invokeOpByName&name=jboss.system:service%3DMainDeployer&methodName=undeploy&argType=java.net.URL&arg0=";
    private String redeployURL = "/jmx-console/HtmlAdaptor?action=invokeOpByName&name=jboss.system:service%3DMainDeployer&methodName=redeploy&argType=java.net.URL&arg0=";
    private RuntimeConfiguration configuration;
    private HttpURLConnection connection;

    public JBossRemoteDeployer(RemoteContainer container) {
        this(container, new JdkHttpURLConnection());
    }

    protected JBossRemoteDeployer(RemoteContainer container, HttpURLConnection connection) {
        this.configuration = container.getConfiguration();
        this.connection = connection;
    }

    public void setDeployURL(String deployURL) {
        this.deployURL = deployURL;
    }

    public void setUndeployURL(String undeployURL) {
        this.undeployURL = undeployURL;
    }

    public void setRedeployURL(String redeployURL) {
        this.redeployURL = redeployURL;
    }

    public void deploy(Deployable deployable) {
        this.invokeURL(this.createJBossRemoteURL(deployable, this.deployURL));
    }

    public void undeploy(Deployable deployable) {
        this.invokeURL(this.createJBossRemoteURL(deployable, this.undeployURL));
    }

    public void redeploy(Deployable deployable) {
        this.invokeURL(this.createJBossRemoteURL(deployable, this.redeployURL));
    }

    private void invokeURL(String url) {
        String username = this.configuration.getPropertyValue("cargo.remote.username");
        String password = this.configuration.getPropertyValue("cargo.remote.password");
        if (username == null) {
            this.getLogger().info("No remote username specified, using default [admin]", ((Object)((Object)this)).getClass().getName());
            username = DEFAULT_USERNAME;
        }
        if (password == null) {
            this.getLogger().info("No remote password specified, using default []", ((Object)((Object)this)).getClass().getName());
            password = DEFAULT_PASSWORD;
        }
        this.connection.connect(url, username, password);
    }

    private String encodeDeployableLocation(Deployable deployable) {
        String encodedString;
        try {
            encodedString = URLEncoder.encode(deployable.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ContainerException("Failed to encode Deployable location [" + deployable.getFile() + "] using an [UTF-8] encoding", (Throwable)e);
        }
        return encodedString;
    }

    protected String createJBossRemoteURL(Deployable deployable, String urlPrefix) {
        return this.configuration.getPropertyValue("cargo.protocol") + "://" + this.configuration.getPropertyValue("cargo.hostname") + ":" + this.configuration.getPropertyValue("cargo.servlet.port") + urlPrefix + "file:" + this.encodeDeployableLocation(deployable);
    }
}

