/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jrun;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.configuration.entry.ResourceSupport;
import org.codehaus.cargo.container.jrun.JRun4xFilterChain;
import org.codehaus.cargo.container.jrun.JRun4xInstalledLocalDeployer;
import org.codehaus.cargo.container.jrun.internal.JRun4xConfigurationBuilder;
import org.codehaus.cargo.container.jrun.internal.JRun4xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder;

public class JRun4xStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder
implements ResourceSupport {
    private static ConfigurationCapability capability = new JRun4xStandaloneLocalConfigurationCapability();

    public JRun4xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.getServerName();
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        this.filterResources(container);
        String to = this.getHome();
        String from = ((InstalledLocalContainer)container).getHome();
        List requiredFiles = this.getRequiredFiles();
        for (int i = 0; i < requiredFiles.size(); ++i) {
            String path = (String)requiredFiles.get(i);
            this.getFileHandler().copyFile(from + "/" + path, to + "/" + path);
        }
        File spaceHotFix = new File(from + "/servers/lib/54101.jar");
        if (spaceHotFix.exists()) {
            this.getFileHandler().copyFile(spaceHotFix.getAbsolutePath(), to + "/servers/lib/54101.jar");
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            this.getFileHandler().copyFile(from + "/bin/jrun.exe", to + "/bin/jrun.exe");
        } else {
            this.getFileHandler().copyFile(from + "/bin/jrun", to + "/bin/jrun");
        }
        InstalledLocalContainer jrunContainer = (InstalledLocalContainer)container;
        JRun4xInstalledLocalDeployer deployer = new JRun4xInstalledLocalDeployer(jrunContainer);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployer.getDeployableDir(), "cargocpc.war"));
    }

    private String getServerName() {
        if (this.getPropertyValue("cargo.jrun.server.name") == null) {
            this.setProperty("cargo.jrun.server.name", "default");
        }
        return this.getPropertyValue("cargo.jrun.server.name");
    }

    private List getRequiredFiles() {
        String serverInfDirectory = "/servers/" + this.getServerName() + "/SERVER-INF/";
        ArrayList<String> files = new ArrayList<String>();
        files.add(serverInfDirectory + "auth.config");
        files.add(serverInfDirectory + "connector.properties");
        files.add(serverInfDirectory + "default-web.xml");
        files.add(serverInfDirectory + "jndi.properties");
        files.add(serverInfDirectory + "jrun-dtd-mappings.xml");
        files.add(serverInfDirectory + "jrun-jms.xml");
        files.add(serverInfDirectory + "jrun-resources.xml");
        files.add(serverInfDirectory + "jrun-security-policy.xml");
        files.add("/lib/jrun.jar");
        files.add("/lib/flashgateway.ear");
        files.add("/lib/jrun-comp.ear");
        files.add("/lib/security.properties");
        files.add("/lib/license.properties");
        files.add("/lib/jrun.policy");
        files.add("/lib/mime.types");
        return files;
    }

    private void filterResources(LocalContainer container) throws IOException {
        JRun4xFilterChain chain = new JRun4xFilterChain(container);
        String to = this.getHome();
        String libDir = this.getFileHandler().createDirectory(to, "lib");
        String resourcePath = "/org/codehaus/cargo/container/internal/resources/" + container.getId();
        this.getResourceUtils().copyResource(resourcePath + "/servers.xml", new File(libDir, "/servers.xml"), (FilterChain)chain);
        this.getFileHandler().createDirectory(to, "bin");
        this.getResourceUtils().copyResource(resourcePath + "/jvm.config", new File(to + "/bin/jvm.config"), (FilterChain)chain);
        String serverInf = "servers/" + this.getServerName() + "/SERVER-INF";
        String serverInfDir = this.getFileHandler().createDirectory(this.getHome(), serverInf);
        this.getResourceUtils().copyResource(resourcePath + "/jrun.xml", new File(serverInfDir, "/jrun.xml"), (FilterChain)chain);
        this.getResourceUtils().copyResource(resourcePath + "/jrun-users.xml", new File(serverInfDir, "/jrun-users.xml"), (FilterChain)chain);
        this.getResourceUtils().copyResource(resourcePath + "/jndi.properties", new File(serverInfDir, "/jndi.properties"), (FilterChain)chain);
    }

    public String toString() {
        return "JRun 4.x Standalone Configuration";
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        return new JRun4xConfigurationBuilder();
    }

    protected Map getNamespaces() {
        return Collections.EMPTY_MAP;
    }

    protected String getXpathForDataSourcesParent() {
        return this.getResourceXPath();
    }

    protected String getOrCreateDataSourceConfigurationFile(DataSource ds, LocalContainer container) {
        return this.getResourceFile(container);
    }

    protected String getOrCreateResourceConfigurationFile(Resource resource, LocalContainer container) {
        return this.getResourceFile(container);
    }

    protected String getXpathForResourcesParent() {
        return this.getResourceXPath();
    }

    private String getResourceFile(LocalContainer container) {
        return this.getFileHandler().append(this.getHome(), "servers/" + this.getServerName() + "/SERVER-INF/jrun-resources.xml");
    }

    private String getResourceXPath() {
        return "//jrun-resources";
    }
}

