/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jrun.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.J2EEContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public abstract class AbstractJRunInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    private String version;
    private ContainerCapability capability = new J2EEContainerCapability();

    public AbstractJRunInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public void doStart(Java java) throws Exception {
        Path classpath = this.doAction(java);
        java.createArg().setValue("-start");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.jrun.server.name"));
        this.startUpAdditions(java, classpath);
        AntContainerExecutorThread jrunRunner = new AntContainerExecutorThread(java);
        jrunRunner.start();
        Thread.sleep(10000L);
    }

    public void doStop(Java java) throws Exception {
        this.doAction(java);
        java.createArg().setValue("-stop");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.jrun.server.name"));
        AntContainerExecutorThread jrunRunner = new AntContainerExecutorThread(java);
        jrunRunner.start();
        Thread.sleep(10000L);
    }

    private Path doAction(Java java) {
        java.addSysproperty(this.getAntUtils().createSysProperty("jrun.home", this.getConfiguration().getHome()));
        java.setClassname("jrunx.kernel.JRun");
        Path classPath = java.createClasspath();
        classPath.setPath(this.getConfiguration().getHome() + "/lib/jrun.jar");
        FileSet libFileSet = new FileSet();
        libFileSet.setDir(new File(this.getHome() + "/lib"));
        libFileSet.setIncludes("webservices.jar,macromedia_drivers.jar");
        classPath.addFileset(libFileSet);
        return classPath;
    }

    protected abstract void startUpAdditions(Java var1, Path var2) throws FileNotFoundException;

    protected String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                JarFile jRunJar = new JarFile(new File(this.getHome(), "/lib/jrun.jar"));
                ZipEntry entry = jRunJar.getEntry("jrunx/kernel/resource.properties");
                if (entry != null) {
                    Properties props = new Properties();
                    props.load(jRunJar.getInputStream(entry));
                    version = props.getProperty("jrun.version");
                } else {
                    version = "4.x";
                }
            }
            catch (Exception e) {
                this.getLogger().debug("Failed to get JRun version, Error = [" + e.getMessage() + "]. Using generic version [" + defaultVersion + "]", ((Object)((Object)this)).getClass().getName());
                version = defaultVersion;
            }
        }
        this.version = version;
        return version;
    }
}

