/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jrun.internal;

import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractConfigurationBuilder;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class JRun4xConfigurationBuilder
extends AbstractConfigurationBuilder {
    public static final String RESOURCE_CONFIGURATION_UNSUPPORTED = "JRun does not support configuration of arbitrary resources into the JNDI tree.";

    protected String configureDataSourceWithImplementationClass(DataSource ds, String className) {
        Element datasourceElement = DocumentHelper.createDocument().addElement("data-source");
        datasourceElement.addElement("dbname").setText(ds.getId());
        datasourceElement.addElement("jndi-name").setText(ds.getJndiLocation());
        datasourceElement.addElement("driver").setText(ds.getDriverClass());
        datasourceElement.addElement("url").setText(ds.getUrl());
        datasourceElement.addElement("username").setText(ds.getUsername());
        datasourceElement.addElement("password").setText(ds.getPassword());
        datasourceElement.addElement("isolation-level").setText("READ_UNCOMMITTED");
        datasourceElement.addElement("native-results").setText("true");
        datasourceElement.addElement("pool-statements").setText("true");
        datasourceElement.addElement("pool-name").setText("pool");
        datasourceElement.addElement("initial-connections").setText("1");
        datasourceElement.addElement("minimum-size").setText("1");
        datasourceElement.addElement("maximum-size").setText("70");
        datasourceElement.addElement("connection-timeout").setText("60");
        datasourceElement.addElement("user-timeout").setText("120");
        datasourceElement.addElement("skimmer-frequency").setText("1800");
        datasourceElement.addElement("shrink-by").setText("10");
        datasourceElement.addElement("debugging").setText("true");
        datasourceElement.addElement("transaction-timeout").setText("10");
        datasourceElement.addElement("cache-enabled").setText("false");
        datasourceElement.addElement("cache-size").setText("10");
        datasourceElement.addElement("remove-on-exceptions").setText("false");
        return datasourceElement.asXML();
    }

    public String buildEntryForDriverConfiguredDataSourceWithLocalTx(DataSource ds) {
        return this.configureDataSourceWithImplementationClass(ds, ds.getDriverClass());
    }

    public String buildEntryForDriverConfiguredDataSourceWithNoTx(DataSource ds) {
        return this.configureDataSourceWithImplementationClass(ds, ds.getDriverClass());
    }

    public String buildEntryForDriverConfiguredDataSourceWithXaTx(DataSource ds) {
        return this.configureDataSourceWithImplementationClass(ds, ds.getDriverClass());
    }

    public String buildConfigurationEntryForXADataSourceConfiguredDataSource(DataSource ds) {
        return this.configureDataSourceWithImplementationClass(ds, ds.getDriverClass());
    }

    public String toConfigurationEntry(Resource resource) {
        throw new UnsupportedOperationException(RESOURCE_CONFIGURATION_UNSUPPORTED);
    }
}

