/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cron;

import it.sauronsoftware.cron4j.InvalidPatternException;
import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.SchedulingPattern;
import it.sauronsoftware.cron4j.Task;
import it.sauronsoftware.cron4j.TaskCollector;
import it.sauronsoftware.cron4j.TaskTable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.cron.CRaSHTask;
import org.crsh.cron.CRaSHTaskDef;
import org.crsh.cron.CRaSHTaskProcess;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.shell.ShellFactory;
import org.crsh.util.Utils;
import org.crsh.vfs.Resource;

public class CronPlugin
extends CRaSHPlugin<CronPlugin>
implements TaskCollector {
    public static PropertyDescriptor<String> CRON_CONFIG_PATH = new PropertyDescriptor<String>(String.class, "cron.config.path", null, "The contrab file path"){

        protected String doParse(String s) throws Exception {
            return s;
        }
    };
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private final Scheduler scheduler = new Scheduler();
    final ConcurrentLinkedQueue<CRaSHTaskProcess> history = new ConcurrentLinkedQueue();
    final CopyOnWriteArrayList<CRaSHTaskProcess> processes = new CopyOnWriteArrayList();

    public CronPlugin getImplementation() {
        return this;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Collections.singleton(CRON_CONFIG_PATH);
    }

    public void init() {
        this.scheduler.addTaskCollector((TaskCollector)this);
        this.scheduler.start();
    }

    public void destroy() {
        this.scheduler.stop();
    }

    public List<CRaSHTaskProcess> getProcesses() {
        return this.processes;
    }

    public Queue<CRaSHTaskProcess> getHistory() {
        return this.history;
    }

    public boolean spawn() {
        try {
            Method spawn = Scheduler.class.getDeclaredMethod("spawnLauncher", Long.TYPE);
            spawn.setAccessible(true);
            spawn.invoke((Object)this.scheduler, System.currentTimeMillis());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Resource getConfig() {
        Resource config = null;
        String configPath = (String)this.getContext().getProperty(CRON_CONFIG_PATH);
        if (configPath != null) {
            File configFile = new File(configPath);
            if (configFile.exists()) {
                this.log.log(Level.FINE, "Found crontab file " + configPath);
                if (configFile.isFile()) {
                    try {
                        config = new Resource("crontab", configFile.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        this.log.log(Level.SEVERE, "Could not retrieve cron config file from " + configPath, e);
                    }
                    catch (IOException e) {
                        this.log.log(Level.FINE, "Could not load cron config file from " + configPath, e);
                    }
                } else {
                    this.log.log(Level.FINE, "Crontab file " + configPath + " is not a file");
                }
            } else {
                this.log.log(Level.FINE, "Crontab file " + configPath + " does not exist");
            }
        } else {
            Resource res = this.getContext().loadResource("crontab", ResourceKind.CONFIG);
            if (res != null) {
                config = res;
                this.log.log(Level.FINE, "Found crontab config url " + res);
            }
        }
        if (config == null) {
            this.log.log(Level.INFO, "No crontab configuration");
        }
        return config;
    }

    public TaskTable getTasks() {
        Resource res = this.getConfig();
        ArrayList<String> lines = null;
        try {
            String cronLine;
            lines = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(res.getContent()), "UTF-8"));
            while ((cronLine = reader.readLine()) != null) {
                lines.add(cronLine);
            }
        }
        catch (IOException e) {
            this.log.log(Level.FINE, "Could not read cron file", e);
        }
        ShellFactory factory = (ShellFactory)this.getContext().getPlugin(ShellFactory.class);
        TaskTable table = new TaskTable();
        for (String cronLine : lines) {
            CRaSHTaskDef crshTask = this.validateAndParseCronLine(cronLine);
            if (crshTask != null) {
                table.add(crshTask.getSchedullingPattern(), (Task)new CRaSHTask(this, factory, crshTask));
                continue;
            }
            this.log.log(Level.FINE, "Cannot parse cron line " + cronLine);
        }
        return table;
    }

    private CRaSHTaskDef validateAndParseCronLine(String cronLine) {
        if ((cronLine = cronLine.trim()).length() == 0 || cronLine.charAt(0) == '#') {
            return null;
        }
        List<String> cronLineParts = Arrays.asList(cronLine.split("\\s+"));
        if (cronLineParts.size() < 6) {
            return null;
        }
        String schedulePart = Utils.join(cronLineParts.subList(0, 5), (String)" ");
        String commandPart = Utils.join(cronLineParts.subList(5, cronLineParts.size()), (String)" ");
        try {
            return new CRaSHTaskDef(new SchedulingPattern(schedulePart), commandPart);
        }
        catch (InvalidPatternException e) {
            return null;
        }
    }
}

