/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.plugin;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.dromara.dynamictp.common.plugin.DtpInterceptor;
import org.dromara.dynamictp.common.plugin.DtpInterceptorProxy;
import org.dromara.dynamictp.common.plugin.DtpIntercepts;
import org.dromara.dynamictp.common.plugin.DtpSignature;
import org.dromara.dynamictp.common.plugin.PluginException;

public class DtpInterceptorProxyFactory {
    private DtpInterceptorProxyFactory() {
    }

    public static Object enhance(Object target, DtpInterceptor interceptor) {
        return DtpInterceptorProxyFactory.enhance(target, null, null, interceptor);
    }

    public static Object enhance(Object target, Class<?>[] argumentTypes, Object[] arguments, DtpInterceptor interceptor) {
        Map<Class<?>, Set<Method>> signatureMap = DtpInterceptorProxyFactory.getSignatureMap(interceptor);
        if (!signatureMap.containsKey(target.getClass())) {
            return target;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(target.getClass());
        enhancer.setCallback((Callback)new DtpInterceptorProxy(target, interceptor, signatureMap));
        if (Objects.isNull(argumentTypes) || Objects.isNull(arguments)) {
            return enhancer.create();
        }
        return enhancer.create((Class[])argumentTypes, arguments);
    }

    private static Map<Class<?>, Set<Method>> getSignatureMap(DtpInterceptor interceptor) {
        DtpIntercepts interceptsAnno = interceptor.getClass().getAnnotation(DtpIntercepts.class);
        if (interceptsAnno == null) {
            throw new PluginException("No @DtpIntercepts annotation was found in interceptor " + interceptor.getClass().getName());
        }
        DtpSignature[] signatures = interceptsAnno.signatures();
        HashMap signatureMap = Maps.newHashMap();
        for (DtpSignature signature : signatures) {
            Set methods = signatureMap.computeIfAbsent(signature.clazz(), k -> new HashSet());
            try {
                Method method = signature.clazz().getMethod(signature.method(), signature.args());
                methods.add(method);
            }
            catch (NoSuchMethodException e) {
                throw new PluginException("Could not find method on " + signature.clazz() + " named " + signature.method() + ". Cause: " + e, e);
            }
        }
        return signatureMap;
    }
}

