/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core;

import com.github.dadiyang.equator.Equator;
import com.github.dadiyang.equator.FieldInfo;
import com.github.dadiyang.equator.GetterBaseEquator;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.constant.DynamicTpConst;
import org.dromara.dynamictp.common.entity.DtpExecutorProps;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.entity.TpExecutorProps;
import org.dromara.dynamictp.common.entity.TpMainFields;
import org.dromara.dynamictp.common.ex.DtpException;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.queue.MemorySafeLinkedBlockingQueue;
import org.dromara.dynamictp.common.queue.VariableLinkedBlockingQueue;
import org.dromara.dynamictp.common.spring.OnceApplicationContextEventListener;
import org.dromara.dynamictp.common.util.StreamUtil;
import org.dromara.dynamictp.core.aware.AwareManager;
import org.dromara.dynamictp.core.converter.ExecutorConverter;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.notifier.manager.NoticeManager;
import org.dromara.dynamictp.core.notifier.manager.NotifyHelper;
import org.dromara.dynamictp.core.reject.RejectHandlerGetter;
import org.dromara.dynamictp.core.support.ExecutorAdapter;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrapper;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.ContextRefreshedEvent;

public class DtpRegistry
extends OnceApplicationContextEventListener {
    private static final Logger log = LoggerFactory.getLogger(DtpRegistry.class);
    private static final Map<String, ExecutorWrapper> EXECUTOR_REGISTRY = new ConcurrentHashMap<String, ExecutorWrapper>();
    private static final Equator EQUATOR = new GetterBaseEquator();
    private static DtpProperties dtpProperties;

    public DtpRegistry(DtpProperties dtpProperties) {
        DtpRegistry.dtpProperties = dtpProperties;
    }

    public static Set<String> getAllExecutorNames() {
        return Collections.unmodifiableSet(EXECUTOR_REGISTRY.keySet());
    }

    public static Map<String, ExecutorWrapper> getAllExecutors() {
        return EXECUTOR_REGISTRY;
    }

    public static void registerExecutor(ExecutorWrapper wrapper, String source) {
        log.info("DynamicTp register executor: {}, source: {}", (Object)ExecutorConverter.toMainFields(wrapper), (Object)source);
        EXECUTOR_REGISTRY.putIfAbsent(wrapper.getThreadPoolName(), wrapper);
    }

    public static DtpExecutor getDtpExecutor(String name) {
        ExecutorWrapper executorWrapper = DtpRegistry.getExecutorWrapper(name);
        if (!executorWrapper.isDtpExecutor()) {
            log.error("The specified executor is not a DtpExecutor, name: {}", (Object)name);
            throw new DtpException("The specified executor is not a DtpExecutor, name: " + name);
        }
        return (DtpExecutor)executorWrapper.getExecutor();
    }

    public static Executor getExecutor(String name) {
        ExecutorWrapper executorWrapper = EXECUTOR_REGISTRY.get(name);
        if (Objects.isNull(executorWrapper)) {
            log.error("Cannot find a specified executor, name: {}", (Object)name);
            throw new DtpException("Cannot find a specified executor, name: " + name);
        }
        return executorWrapper.getExecutor();
    }

    public static ExecutorWrapper getExecutorWrapper(String name) {
        ExecutorWrapper executorWrapper = EXECUTOR_REGISTRY.get(name);
        if (Objects.isNull(executorWrapper)) {
            log.error("Cannot find a specified executorWrapper, name: {}", (Object)name);
            throw new DtpException("Cannot find a specified executorWrapper, name: " + name);
        }
        return executorWrapper;
    }

    public static void refresh(DtpProperties dtpProperties) {
        if (Objects.isNull(dtpProperties) || CollectionUtils.isEmpty((Collection)dtpProperties.getExecutors())) {
            log.debug("DynamicTp refresh, empty thread pool properties.");
            return;
        }
        dtpProperties.getExecutors().forEach(p -> {
            if (StringUtils.isBlank((CharSequence)p.getThreadPoolName())) {
                log.warn("DynamicTp refresh, thread pool name must not be blank, executorProps: {}", p);
                return;
            }
            ExecutorWrapper executorWrapper = EXECUTOR_REGISTRY.get(p.getThreadPoolName());
            if (Objects.nonNull(executorWrapper)) {
                DtpRegistry.refresh(executorWrapper, p);
                return;
            }
            log.warn("DynamicTp refresh, cannot find specified executor, name: {}.", (Object)p.getThreadPoolName());
        });
    }

    private static void refresh(ExecutorWrapper executorWrapper, DtpExecutorProps props) {
        if (props.coreParamIsInValid()) {
            log.error("DynamicTp refresh, invalid parameters exist, properties: {}", (Object)props);
            throw new IllegalArgumentException("DynamicTp refresh, invalid parameters exist, properties: " + props);
        }
        TpMainFields oldFields = ExecutorConverter.toMainFields(executorWrapper);
        DtpRegistry.doRefresh(executorWrapper, props);
        TpMainFields newFields = ExecutorConverter.toMainFields(executorWrapper);
        if (oldFields.equals((Object)newFields)) {
            log.debug("DynamicTp refresh, main properties of [{}] have not changed.", (Object)executorWrapper.getThreadPoolName());
            return;
        }
        List diffFields = EQUATOR.getDiffFields((Object)oldFields, (Object)newFields);
        List diffKeys = StreamUtil.fetchProperty((Collection)diffFields, FieldInfo::getFieldName);
        NoticeManager.tryNoticeAsync(executorWrapper, oldFields, diffKeys);
        log.info("DynamicTp refresh, tpName: [{}], changed keys: {}, corePoolSize: [{}], maxPoolSize: [{}], queueType: [{}], queueCapacity: [{}], keepAliveTime: [{}], rejectedType: [{}], allowsCoreThreadTimeOut: [{}]", new Object[]{executorWrapper.getThreadPoolName(), diffKeys, String.format("%s => %s", oldFields.getCorePoolSize(), newFields.getCorePoolSize()), String.format("%s => %s", oldFields.getMaxPoolSize(), newFields.getMaxPoolSize()), String.format("%s => %s", oldFields.getQueueType(), newFields.getQueueType()), String.format("%s => %s", oldFields.getQueueCapacity(), newFields.getQueueCapacity()), String.format("%ss => %ss", oldFields.getKeepAliveTime(), newFields.getKeepAliveTime()), String.format("%s => %s", oldFields.getRejectType(), newFields.getRejectType()), String.format("%s => %s", oldFields.isAllowCoreThreadTimeOut(), newFields.isAllowCoreThreadTimeOut())});
    }

    private static void doRefresh(ExecutorWrapper executorWrapper, DtpExecutorProps props) {
        ExecutorAdapter<?> executor = executorWrapper.getExecutor();
        DtpRegistry.doRefreshPoolSize(executor, props);
        if (!Objects.equals(executor.getKeepAliveTime(props.getUnit()), props.getKeepAliveTime())) {
            executor.setKeepAliveTime(props.getKeepAliveTime(), props.getUnit());
        }
        if (!Objects.equals(executor.allowsCoreThreadTimeOut(), props.isAllowCoreThreadTimeOut())) {
            executor.allowCoreThreadTimeOut(props.isAllowCoreThreadTimeOut());
        }
        DtpRegistry.updateQueueProps(executor, props);
        if (executorWrapper.isDtpExecutor()) {
            DtpRegistry.doRefreshDtp(executorWrapper, props);
            return;
        }
        DtpRegistry.doRefreshCommon(executorWrapper, props);
    }

    private static void doRefreshCommon(ExecutorWrapper executorWrapper, DtpExecutorProps props) {
        ExecutorAdapter<?> executor;
        String currentRejectHandlerType;
        if (StringUtils.isNotBlank((CharSequence)props.getThreadPoolAliasName())) {
            executorWrapper.setThreadPoolAliasName(props.getThreadPoolAliasName());
        }
        if (!Objects.equals(currentRejectHandlerType = (executor = executorWrapper.getExecutor()).getRejectHandlerType(), props.getRejectedHandlerType())) {
            RejectedExecutionHandler rejectHandler = RejectHandlerGetter.buildRejectedHandler(props.getRejectedHandlerType());
            executor.setRejectedExecutionHandler(rejectHandler);
        }
        List<TaskWrapper> taskWrappers = TaskWrappers.getInstance().getByNames(props.getTaskWrapperNames());
        executorWrapper.setTaskWrappers(taskWrappers);
        NotifyHelper.updateNotifyInfo(executorWrapper, (TpExecutorProps)props, (List<NotifyPlatform>)dtpProperties.getPlatforms());
        AwareManager.refresh(executorWrapper, (TpExecutorProps)props);
    }

    private static void doRefreshDtp(ExecutorWrapper executorWrapper, DtpExecutorProps props) {
        DtpExecutor executor = (DtpExecutor)executorWrapper.getExecutor();
        if (StringUtils.isNotBlank((CharSequence)props.getThreadPoolAliasName())) {
            executor.setThreadPoolAliasName(props.getThreadPoolAliasName());
        }
        executor.setRejectEnhanced(props.isRejectEnhanced());
        if (!Objects.equals(executor.getRejectHandlerType(), props.getRejectedHandlerType())) {
            executor.setRejectHandler(RejectHandlerGetter.buildRejectedHandler(props.getRejectedHandlerType()));
        }
        executor.setWaitForTasksToCompleteOnShutdown(props.isWaitForTasksToCompleteOnShutdown());
        executor.setAwaitTerminationSeconds(props.getAwaitTerminationSeconds());
        executor.setPreStartAllCoreThreads(props.isPreStartAllCoreThreads());
        List<TaskWrapper> taskWrappers = TaskWrappers.getInstance().getByNames(props.getTaskWrapperNames());
        executor.setTaskWrappers(taskWrappers);
        NotifyHelper.updateNotifyInfo(executor, props, (List<NotifyPlatform>)dtpProperties.getPlatforms());
        AwareManager.refresh(executorWrapper, (TpExecutorProps)props);
        DtpRegistry.updateWrapper(executorWrapper, executor);
    }

    private static void updateWrapper(ExecutorWrapper executorWrapper, DtpExecutor executor) {
        executorWrapper.setThreadPoolAliasName(executor.getThreadPoolAliasName());
        executorWrapper.setNotifyItems(executor.getNotifyItems());
        executorWrapper.setPlatformIds(executor.getPlatformIds());
        executorWrapper.setNotifyEnabled(executor.isNotifyEnabled());
    }

    private static void doRefreshPoolSize(ExecutorAdapter<?> executor, DtpExecutorProps props) {
        if (props.getMaximumPoolSize() < executor.getMaximumPoolSize()) {
            if (!Objects.equals(executor.getCorePoolSize(), props.getCorePoolSize())) {
                executor.setCorePoolSize(props.getCorePoolSize());
            }
            if (!Objects.equals(executor.getMaximumPoolSize(), props.getMaximumPoolSize())) {
                executor.setMaximumPoolSize(props.getMaximumPoolSize());
            }
            return;
        }
        if (!Objects.equals(executor.getMaximumPoolSize(), props.getMaximumPoolSize())) {
            executor.setMaximumPoolSize(props.getMaximumPoolSize());
        }
        if (!Objects.equals(executor.getCorePoolSize(), props.getCorePoolSize())) {
            executor.setCorePoolSize(props.getCorePoolSize());
        }
    }

    private static void updateQueueProps(ExecutorAdapter<?> executor, DtpExecutorProps props) {
        BlockingQueue<Runnable> blockingQueue = executor.getQueue();
        if (blockingQueue instanceof MemorySafeLinkedBlockingQueue) {
            ((MemorySafeLinkedBlockingQueue)blockingQueue).setMaxFreeMemory(props.getMaxFreeMemory() * DynamicTpConst.M_1);
        }
        if (blockingQueue instanceof VariableLinkedBlockingQueue) {
            int capacity = blockingQueue.size() + blockingQueue.remainingCapacity();
            if (!Objects.equals(capacity, props.getQueueCapacity())) {
                ((VariableLinkedBlockingQueue)blockingQueue).setCapacity(props.getQueueCapacity());
                executor.onRefreshQueueCapacity(props.getQueueCapacity());
            }
            return;
        }
        log.warn("DynamicTp refresh, the blockingqueue capacity cannot be reset, poolName: {}, queueType {}", (Object)props.getThreadPoolName(), (Object)blockingQueue.getClass().getSimpleName());
    }

    protected void onContextRefreshedEvent(ContextRefreshedEvent event) {
        Set remoteExecutors = Collections.emptySet();
        if (CollectionUtils.isNotEmpty((Collection)dtpProperties.getExecutors())) {
            remoteExecutors = dtpProperties.getExecutors().stream().map(TpExecutorProps::getThreadPoolName).collect(Collectors.toSet());
        }
        HashSet registeredExecutors = Sets.newHashSet(EXECUTOR_REGISTRY.keySet());
        Collection localExecutors = CollectionUtils.subtract((Iterable)registeredExecutors, remoteExecutors);
        log.info("DtpRegistry has been initialized, remote executors: {}, local executors: {}", remoteExecutors, (Object)localExecutors);
    }
}

