/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.aware;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.common.entity.TpExecutorProps;
import org.dromara.dynamictp.common.util.ExtensionServiceLoader;
import org.dromara.dynamictp.core.aware.ExecutorAware;
import org.dromara.dynamictp.core.aware.PerformanceMonitorAware;
import org.dromara.dynamictp.core.aware.TaskRejectAware;
import org.dromara.dynamictp.core.aware.TaskTimeoutAware;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwareManager {
    private static final Logger log = LoggerFactory.getLogger(AwareManager.class);
    private static final List<ExecutorAware> EXECUTOR_AWARE_LIST = new ArrayList<ExecutorAware>();

    private AwareManager() {
    }

    public static void add(ExecutorAware aware) {
        for (ExecutorAware executorAware : EXECUTOR_AWARE_LIST) {
            if (!executorAware.getName().equalsIgnoreCase(aware.getName())) continue;
            return;
        }
        EXECUTOR_AWARE_LIST.add(aware);
        EXECUTOR_AWARE_LIST.sort(Comparator.comparingInt(ExecutorAware::getOrder));
    }

    public static void register(ExecutorWrapper executorWrapper) {
        for (ExecutorAware executorAware : EXECUTOR_AWARE_LIST) {
            Set<String> awareNames = executorWrapper.getAwareNames();
            if (!CollectionUtils.isEmpty(awareNames) && !awareNames.contains(executorAware.getName())) continue;
            executorAware.register(executorWrapper);
        }
    }

    public static void refresh(ExecutorWrapper executorWrapper, TpExecutorProps props) {
        for (ExecutorAware executorAware : EXECUTOR_AWARE_LIST) {
            List awareNames = props.getAwareNames();
            if (CollectionUtils.isEmpty((Collection)awareNames) || awareNames.contains(executorAware.getName())) {
                executorAware.refresh(executorWrapper, props);
                continue;
            }
            executorAware.remove(executorWrapper);
        }
    }

    public static void execute(Executor executor, Runnable r) {
        for (ExecutorAware aware : EXECUTOR_AWARE_LIST) {
            try {
                aware.execute(executor, r);
            }
            catch (Exception e) {
                log.error("DynamicTp aware [{}], enhance execute error.", (Object)aware.getName(), (Object)e);
            }
        }
    }

    public static void beforeExecute(Executor executor, Thread t, Runnable r) {
        for (ExecutorAware aware : EXECUTOR_AWARE_LIST) {
            try {
                aware.beforeExecute(executor, t, r);
            }
            catch (Exception e) {
                log.error("DynamicTp aware [{}], enhance beforeExecute error.", (Object)aware.getName(), (Object)e);
            }
        }
    }

    public static void afterExecute(Executor executor, Runnable r, Throwable t) {
        for (ExecutorAware aware : EXECUTOR_AWARE_LIST) {
            try {
                aware.afterExecute(executor, r, t);
            }
            catch (Exception e) {
                log.error("DynamicTp aware [{}], enhance afterExecute error.", (Object)aware.getName(), (Object)e);
            }
        }
    }

    public static void shutdown(Executor executor) {
        for (ExecutorAware aware : EXECUTOR_AWARE_LIST) {
            try {
                aware.shutdown(executor);
            }
            catch (Exception e) {
                log.error("DynamicTp aware [{}], enhance shutdown error.", (Object)aware.getName(), (Object)e);
            }
        }
    }

    public static void shutdownNow(Executor executor, List<Runnable> tasks) {
        for (ExecutorAware aware : EXECUTOR_AWARE_LIST) {
            try {
                aware.shutdownNow(executor, tasks);
            }
            catch (Exception e) {
                log.error("DynamicTp aware [{}], enhance shutdownNow error.", (Object)aware.getName(), (Object)e);
            }
        }
    }

    public static void terminated(Executor executor) {
        for (ExecutorAware aware : EXECUTOR_AWARE_LIST) {
            try {
                aware.terminated(executor);
            }
            catch (Exception e) {
                log.error("DynamicTp aware [{}], enhance terminated error.", (Object)aware.getName(), (Object)e);
            }
        }
    }

    public static void beforeReject(Runnable r, Executor executor) {
        for (ExecutorAware aware : EXECUTOR_AWARE_LIST) {
            try {
                aware.beforeReject(r, executor);
            }
            catch (Exception e) {
                log.error("DynamicTp aware [{}], enhance beforeReject error.", (Object)aware.getName(), (Object)e);
            }
        }
    }

    public static void afterReject(Runnable r, Executor executor) {
        for (ExecutorAware aware : EXECUTOR_AWARE_LIST) {
            try {
                aware.afterReject(r, executor);
            }
            catch (Exception e) {
                log.error("DynamicTp aware [{}], enhance afterReject error.", (Object)aware.getName(), (Object)e);
            }
        }
    }

    static {
        EXECUTOR_AWARE_LIST.add(new PerformanceMonitorAware());
        EXECUTOR_AWARE_LIST.add(new TaskTimeoutAware());
        EXECUTOR_AWARE_LIST.add(new TaskRejectAware());
        List serviceLoader = ExtensionServiceLoader.get(ExecutorAware.class);
        EXECUTOR_AWARE_LIST.addAll(serviceLoader);
        EXECUTOR_AWARE_LIST.sort(Comparator.comparingInt(ExecutorAware::getOrder));
    }
}

