/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.aware;

import cn.hutool.core.text.CharSequenceUtil;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.core.aware.AwareTypeEnum;
import org.dromara.dynamictp.core.aware.TaskStatAware;
import org.dromara.dynamictp.core.notifier.manager.AlarmManager;
import org.dromara.dynamictp.core.support.ExecutorAdapter;
import org.dromara.dynamictp.core.support.ThreadPoolStatProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TaskRejectAware
extends TaskStatAware {
    private static final Logger log = LoggerFactory.getLogger(TaskRejectAware.class);

    @Override
    public int getOrder() {
        return AwareTypeEnum.TASK_REJECT_AWARE.getOrder();
    }

    @Override
    public String getName() {
        return AwareTypeEnum.TASK_REJECT_AWARE.getName();
    }

    @Override
    public void beforeReject(Runnable runnable, Executor executor) {
        ThreadPoolStatProvider statProvider = (ThreadPoolStatProvider)this.statProviders.get(executor);
        if (Objects.isNull(statProvider)) {
            return;
        }
        statProvider.incRejectCount(1);
        AlarmManager.tryAlarmAsync(statProvider.getExecutorWrapper(), NotifyItemEnum.REJECT, runnable);
        ExecutorAdapter<?> executorAdapter = statProvider.getExecutorWrapper().getExecutor();
        String logMsg = CharSequenceUtil.format((CharSequence)"DynamicTp execute, thread pool is exhausted, tpName: {},  traceId: {}, poolSize: {} (active: {}, core: {}, max: {}, largest: {}), task: {} (completed: {}), queueCapacity: {}, (currSize: {}, remaining: {}) ,executorStatus: (isShutdown: {}, isTerminated: {}, isTerminating: {})", (Object[])new Object[]{statProvider.getExecutorWrapper().getThreadPoolName(), MDC.get((String)"traceId"), executorAdapter.getPoolSize(), executorAdapter.getActiveCount(), executorAdapter.getCorePoolSize(), executorAdapter.getMaximumPoolSize(), executorAdapter.getLargestPoolSize(), executorAdapter.getTaskCount(), executorAdapter.getCompletedTaskCount(), statProvider.getExecutorWrapper().getExecutor().getQueueCapacity(), executorAdapter.getQueue().size(), executorAdapter.getQueue().remainingCapacity(), executorAdapter.isShutdown(), executorAdapter.isTerminated(), executorAdapter.isTerminating()});
        log.warn(logMsg);
    }
}

