/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.aware;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.dromara.dynamictp.common.entity.TpExecutorProps;
import org.dromara.dynamictp.core.aware.ExecutorAware;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolStatProvider;

public abstract class TaskStatAware
implements ExecutorAware {
    protected final Map<Executor, ThreadPoolStatProvider> statProviders = new ConcurrentHashMap<Executor, ThreadPoolStatProvider>();

    @Override
    public void register(ExecutorWrapper wrapper) {
        ThreadPoolStatProvider statProvider = wrapper.getThreadPoolStatProvider();
        this.statProviders.put(wrapper.getExecutor(), statProvider);
        this.statProviders.put((Executor)wrapper.getExecutor().getOriginal(), statProvider);
    }

    @Override
    public void refresh(ExecutorWrapper wrapper, TpExecutorProps props) {
        if (Objects.isNull(this.statProviders.get(wrapper.getExecutor()))) {
            this.register(wrapper);
        }
        ThreadPoolStatProvider statProvider = wrapper.getThreadPoolStatProvider();
        this.refresh(props, statProvider);
    }

    @Override
    public void remove(ExecutorWrapper wrapper) {
        this.statProviders.remove(wrapper.getExecutor());
        this.statProviders.remove(wrapper.getExecutor().getOriginal());
    }

    protected void refresh(TpExecutorProps props, ThreadPoolStatProvider statProvider) {
    }
}

