/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.aware;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.dromara.dynamictp.common.entity.TpExecutorProps;
import org.dromara.dynamictp.core.aware.AwareTypeEnum;
import org.dromara.dynamictp.core.aware.TaskStatAware;
import org.dromara.dynamictp.core.support.ThreadPoolStatProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTimeoutAware
extends TaskStatAware {
    private static final Logger log = LoggerFactory.getLogger(TaskTimeoutAware.class);

    @Override
    public int getOrder() {
        return AwareTypeEnum.TASK_TIMEOUT_AWARE.getOrder();
    }

    @Override
    public String getName() {
        return AwareTypeEnum.TASK_TIMEOUT_AWARE.getName();
    }

    @Override
    protected void refresh(TpExecutorProps props, ThreadPoolStatProvider statProvider) {
        super.refresh(props, statProvider);
        if (Objects.nonNull(props)) {
            statProvider.setRunTimeout(props.getRunTimeout());
            statProvider.setQueueTimeout(props.getQueueTimeout());
            statProvider.setTryInterrupt(props.isTryInterrupt());
        }
    }

    @Override
    public void execute(Executor executor, Runnable r) {
        if ("true".equals(System.getProperty("dtp.execute.enhanced", "true"))) {
            Optional.ofNullable(this.statProviders.get(executor)).ifPresent(p -> p.startQueueTimeoutTask(r));
        }
    }

    @Override
    public void beforeExecute(Executor executor, Thread t, Runnable r) {
        Optional.ofNullable(this.statProviders.get(executor)).ifPresent(p -> {
            p.cancelQueueTimeoutTask(r);
            p.startRunTimeoutTask(t, r);
        });
    }

    @Override
    public void afterExecute(Executor executor, Runnable r, Throwable t) {
        Optional.ofNullable(this.statProviders.get(executor)).ifPresent(p -> p.cancelRunTimeoutTask(r));
    }

    @Override
    public void beforeReject(Runnable r, Executor executor) {
        Optional.ofNullable(this.statProviders.get(executor)).ifPresent(p -> p.cancelQueueTimeoutTask(r));
    }
}

