/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.converter;

import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.common.entity.ThreadPoolStats;
import org.dromara.dynamictp.common.entity.TpMainFields;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.monitor.PerformanceProvider;
import org.dromara.dynamictp.core.support.ExecutorAdapter;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolStatProvider;

public class ExecutorConverter {
    private ExecutorConverter() {
    }

    public static TpMainFields toMainFields(ExecutorWrapper executorWrapper) {
        TpMainFields mainFields = new TpMainFields();
        mainFields.setThreadPoolName(executorWrapper.getThreadPoolName());
        ExecutorAdapter<?> executor = executorWrapper.getExecutor();
        mainFields.setCorePoolSize(executor.getCorePoolSize());
        mainFields.setMaxPoolSize(executor.getMaximumPoolSize());
        mainFields.setKeepAliveTime(executor.getKeepAliveTime(TimeUnit.SECONDS));
        mainFields.setQueueType(executor.getQueueType());
        mainFields.setQueueCapacity(executor.getQueueCapacity());
        mainFields.setAllowCoreThreadTimeOut(executor.allowsCoreThreadTimeOut());
        mainFields.setRejectType(executor.getRejectHandlerType());
        return mainFields;
    }

    public static ThreadPoolStats toMetrics(ExecutorWrapper wrapper) {
        ExecutorAdapter<?> executor = wrapper.getExecutor();
        if (executor == null) {
            return null;
        }
        ThreadPoolStatProvider provider = wrapper.getThreadPoolStatProvider();
        PerformanceProvider performanceProvider = provider.getPerformanceProvider();
        PerformanceProvider.PerformanceSnapshot performanceSnapshot = performanceProvider.getSnapshotAndReset();
        ThreadPoolStats poolStats = ExecutorConverter.convertCommon(executor);
        poolStats.setPoolName(wrapper.getThreadPoolName());
        poolStats.setPoolAliasName(wrapper.getThreadPoolAliasName());
        poolStats.setRunTimeoutCount(provider.getRunTimeoutCount());
        poolStats.setQueueTimeoutCount(provider.getQueueTimeoutCount());
        poolStats.setRejectCount(provider.getRejectedTaskCount());
        poolStats.setDynamic(executor instanceof DtpExecutor);
        poolStats.setTps(performanceSnapshot.getTps());
        poolStats.setAvg(performanceSnapshot.getAvg());
        poolStats.setMaxRt(performanceSnapshot.getMaxRt());
        poolStats.setMinRt(performanceSnapshot.getMinRt());
        poolStats.setTp50(performanceSnapshot.getTp50());
        poolStats.setTp75(performanceSnapshot.getTp75());
        poolStats.setTp90(performanceSnapshot.getTp90());
        poolStats.setTp95(performanceSnapshot.getTp95());
        poolStats.setTp99(performanceSnapshot.getTp99());
        poolStats.setTp999(performanceSnapshot.getTp999());
        return poolStats;
    }

    private static ThreadPoolStats convertCommon(ExecutorAdapter<?> executor) {
        ThreadPoolStats poolStats = new ThreadPoolStats();
        poolStats.setCorePoolSize(executor.getCorePoolSize());
        poolStats.setMaximumPoolSize(executor.getMaximumPoolSize());
        poolStats.setPoolSize(executor.getPoolSize());
        poolStats.setActiveCount(executor.getActiveCount());
        poolStats.setLargestPoolSize(executor.getLargestPoolSize());
        poolStats.setQueueType(executor.getQueueType());
        poolStats.setQueueCapacity(executor.getQueueCapacity());
        poolStats.setQueueSize(executor.getQueueSize());
        poolStats.setQueueRemainingCapacity(executor.getQueueRemainingCapacity());
        poolStats.setTaskCount(executor.getTaskCount());
        poolStats.setCompletedTaskCount(executor.getCompletedTaskCount());
        poolStats.setWaitTaskCount(executor.getQueueSize());
        poolStats.setRejectHandlerName(executor.getRejectHandlerType());
        return poolStats;
    }
}

