/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.executor;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(NamedThreadFactory.class);
    private final ThreadGroup group;
    private final String namePrefix;
    private final boolean daemon;
    private final Integer priority;
    private final AtomicInteger seq = new AtomicInteger(1);

    public NamedThreadFactory(String namePrefix, boolean daemon, int priority) {
        this.daemon = daemon;
        this.priority = priority;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix;
    }

    public NamedThreadFactory(String namePrefix) {
        this(namePrefix, false, 5);
    }

    public NamedThreadFactory(String namePrefix, boolean daemon) {
        this(namePrefix, daemon, 5);
    }

    @Override
    public Thread newThread(Runnable r) {
        String name = this.namePrefix + "-" + this.seq.getAndIncrement();
        Thread t = new Thread(this.group, r, name);
        t.setDaemon(this.daemon);
        t.setPriority(this.priority);
        return t;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }
}

