/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.executor;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.dromara.dynamictp.common.queue.VariableLinkedBlockingQueue;
import org.dromara.dynamictp.core.aware.AwareManager;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.support.selector.ExecutorSelector;
import org.dromara.dynamictp.core.support.selector.HashedExecutorSelector;
import org.dromara.dynamictp.core.support.task.Ordered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedDtpExecutor
extends DtpExecutor {
    private static final Logger log = LoggerFactory.getLogger(OrderedDtpExecutor.class);
    private final ExecutorSelector selector = new HashedExecutorSelector();
    private final List<Executor> childExecutors = Lists.newArrayList();

    public OrderedDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    }

    public OrderedDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public OrderedDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public OrderedDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        for (int i = 0; i < corePoolSize; ++i) {
            ChildExecutor childExecutor = new ChildExecutor(workQueue.size() + workQueue.remainingCapacity());
            this.childExecutors.add(childExecutor);
        }
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        if (command instanceof Ordered) {
            this.doOrderedExecute(command, ((Ordered)((Object)command)).hashKey());
        } else {
            this.doUnorderedExecute(command);
        }
    }

    public void execute(Runnable command, Object hashKey) {
        if (Objects.nonNull(hashKey)) {
            this.doOrderedExecute(command, hashKey);
        } else {
            this.doUnorderedExecute(command);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Object hashKey = task instanceof Ordered ? ((Ordered)((Object)task)).hashKey() : null;
        RunnableFuture<T> futureTask = this.newTaskFor(task);
        this.execute(futureTask, hashKey);
        return futureTask;
    }

    public <T> Future<T> submit(Callable<T> task, Object hashKey) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> futureTask = this.newTaskFor(task);
        this.execute(futureTask, hashKey);
        return futureTask;
    }

    private void doOrderedExecute(Runnable command, Object hashKey) {
        Executor executor = this.selector.select(this.childExecutors, hashKey);
        executor.execute(command);
    }

    private void doUnorderedExecute(Runnable command) {
        super.execute(command);
    }

    void onBeforeExecute(Thread t, Runnable r) {
        this.beforeExecute(t, r);
    }

    void onAfterExecute(Runnable r, Throwable t) {
        this.afterExecute(r, t);
    }

    @Override
    public long getCompletedTaskCount() {
        long count = 0L;
        for (Executor executor : this.childExecutors) {
            count += ((ChildExecutor)executor).getCompletedTaskCount();
        }
        return super.getCompletedTaskCount() + count;
    }

    @Override
    public long getTaskCount() {
        long count = 0L;
        for (Executor executor : this.childExecutors) {
            count += ((ChildExecutor)executor).getTaskCount();
        }
        return super.getTaskCount() + count;
    }

    @Override
    public void onRefreshQueueCapacity(int capacity) {
        for (Executor executor : this.childExecutors) {
            ChildExecutor childExecutor = (ChildExecutor)executor;
            if (!(childExecutor.getTaskQueue() instanceof VariableLinkedBlockingQueue)) continue;
            ((VariableLinkedBlockingQueue)childExecutor.getTaskQueue()).setCapacity(capacity);
        }
    }

    private final class ChildExecutor
    implements Executor,
    Runnable {
        private final BlockingQueue<Runnable> taskQueue;
        private final LongAdder completedTaskCount = new LongAdder();
        private final LongAdder rejectedTaskCount = new LongAdder();
        private boolean running;

        ChildExecutor(int queueSize) {
            if (queueSize <= 0) {
                this.taskQueue = new SynchronousQueue<Runnable>();
                return;
            }
            this.taskQueue = new VariableLinkedBlockingQueue(queueSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            boolean start = false;
            command = OrderedDtpExecutor.this.getEnhancedTask(command, OrderedDtpExecutor.this.getTaskWrappers());
            ChildExecutor childExecutor = this;
            synchronized (childExecutor) {
                try {
                    if (!this.taskQueue.add(command)) {
                        this.rejectedTaskIncrement(command);
                        throw new RejectedExecutionException("Task " + command + " rejected from " + this);
                    }
                }
                catch (IllegalStateException ex) {
                    this.rejectedTaskIncrement(command);
                    throw ex;
                }
                if (!this.running) {
                    this.running = true;
                    start = true;
                }
            }
            if (start) {
                OrderedDtpExecutor.this.doUnorderedExecute(this);
            }
        }

        @Override
        public void run() {
            Runnable task;
            Thread thread = Thread.currentThread();
            while ((task = this.getTask()) != null) {
                OrderedDtpExecutor.this.onBeforeExecute(thread, task);
                RuntimeException thrown = null;
                try {
                    task.run();
                }
                catch (RuntimeException x) {
                    thrown = x;
                    throw x;
                }
                finally {
                    OrderedDtpExecutor.this.onAfterExecute(task, thrown);
                    this.completedTaskCount.increment();
                }
            }
        }

        private void rejectedTaskIncrement(Runnable runnable) {
            AwareManager.beforeReject(runnable, OrderedDtpExecutor.this);
            this.rejectedTaskCount.increment();
        }

        private synchronized Runnable getTask() {
            Runnable task = (Runnable)this.taskQueue.poll();
            if (task == null) {
                this.running = false;
            }
            return task;
        }

        public BlockingQueue<Runnable> getTaskQueue() {
            return this.taskQueue;
        }

        public long getTaskCount() {
            return this.completedTaskCount.sum() + (long)this.taskQueue.size();
        }

        public long getCompletedTaskCount() {
            return this.completedTaskCount.sum();
        }

        public String toString() {
            return super.toString() + "[queue size = " + this.taskQueue.size() + ", completed tasks = " + this.completedTaskCount + ", rejected tasks = " + this.rejectedTaskCount + ", running = " + this.running + "]";
        }
    }
}

