/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.executor.priority;

import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.executor.priority.Priority;
import org.dromara.dynamictp.core.executor.priority.PriorityCallable;
import org.dromara.dynamictp.core.executor.priority.PriorityFutureTask;
import org.dromara.dynamictp.core.executor.priority.PriorityRunnable;
import org.dromara.dynamictp.core.support.task.runnable.DtpRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityDtpExecutor
extends DtpExecutor {
    private static final Logger log = LoggerFactory.getLogger(PriorityDtpExecutor.class);

    public PriorityDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int capacity) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(capacity), Executors.defaultThreadFactory(), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
    }

    public PriorityDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int capacity, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(capacity), threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
    }

    public PriorityDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int capacity, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(capacity), Executors.defaultThreadFactory(), handler);
    }

    public PriorityDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int capacity, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingQueue<Runnable>(capacity), threadFactory, handler);
    }

    public PriorityDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, PriorityBlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    }

    public PriorityDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, PriorityBlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
    }

    public PriorityDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, PriorityBlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public PriorityDtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, PriorityBlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new PriorityFutureTask<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new PriorityFutureTask<T>(callable);
    }

    public void execute(Runnable command, int priority) {
        super.execute(PriorityRunnable.of(command, priority));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(PriorityRunnable.of(task, Integer.MAX_VALUE));
    }

    public Future<?> submit(Runnable task, int priority) {
        return super.submit(PriorityRunnable.of(task, priority));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return super.submit(PriorityRunnable.of(task, Integer.MAX_VALUE), result);
    }

    public <T> Future<T> submit(Runnable task, T result, int priority) {
        return super.submit(PriorityRunnable.of(task, priority), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(PriorityCallable.of(task, Integer.MAX_VALUE));
    }

    public <T> Future<T> submit(Callable<T> task, int priority) {
        return super.submit(PriorityCallable.of(task, priority));
    }

    public static Comparator<Runnable> getRunnableComparator() {
        return (o1, o2) -> {
            if (!(o1 instanceof DtpRunnable) || !(o2 instanceof DtpRunnable)) {
                return 0;
            }
            Runnable po1 = ((DtpRunnable)o1).getOriginRunnable();
            Runnable po2 = ((DtpRunnable)o2).getOriginRunnable();
            if (po1 instanceof Priority && po2 instanceof Priority) {
                return Integer.compare(((Priority)((Object)po1)).getPriority(), ((Priority)((Object)po2)).getPriority());
            }
            return 0;
        };
    }
}

