/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.handler;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.dromara.dynamictp.common.entity.ThreadPoolStats;
import org.dromara.dynamictp.common.util.ExtensionServiceLoader;
import org.dromara.dynamictp.core.monitor.collector.InternalLogCollector;
import org.dromara.dynamictp.core.monitor.collector.LogCollector;
import org.dromara.dynamictp.core.monitor.collector.MetricsCollector;
import org.dromara.dynamictp.core.monitor.collector.MicroMeterCollector;
import org.dromara.dynamictp.core.monitor.collector.jmx.JMXCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class CollectorHandler {
    private static final Logger log = LoggerFactory.getLogger(CollectorHandler.class);
    private static final Map<String, MetricsCollector> COLLECTORS = Maps.newHashMap();

    private CollectorHandler() {
        List loadedCollectors = ExtensionServiceLoader.get(MetricsCollector.class);
        loadedCollectors.forEach(collector -> COLLECTORS.put(collector.type(), (MetricsCollector)collector));
        MicroMeterCollector microMeterCollector = new MicroMeterCollector();
        LogCollector logCollector = new LogCollector();
        InternalLogCollector internalLogCollector = new InternalLogCollector();
        JMXCollector jmxCollector = new JMXCollector();
        COLLECTORS.put(microMeterCollector.type(), microMeterCollector);
        COLLECTORS.put(logCollector.type(), logCollector);
        COLLECTORS.put(internalLogCollector.type(), internalLogCollector);
        COLLECTORS.put(jmxCollector.type(), jmxCollector);
    }

    public void collect(ThreadPoolStats poolStats, List<String> types) {
        if (poolStats == null || CollectionUtils.isEmpty(types)) {
            return;
        }
        for (String collectorType : types) {
            MetricsCollector collector = COLLECTORS.get(collectorType.toLowerCase());
            if (collector == null) continue;
            collector.collect(poolStats);
        }
    }

    public static CollectorHandler getInstance() {
        return CollectorHandlerHolder.INSTANCE;
    }

    private static class CollectorHandlerHolder {
        private static final CollectorHandler INSTANCE = new CollectorHandler();

        private CollectorHandlerHolder() {
        }
    }
}

