/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.handler;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.common.em.ConfigFileTypeEnum;
import org.dromara.dynamictp.common.parser.config.ConfigParser;
import org.dromara.dynamictp.common.parser.config.JsonConfigParser;
import org.dromara.dynamictp.common.parser.config.PropertiesConfigParser;
import org.dromara.dynamictp.common.parser.config.YamlConfigParser;
import org.dromara.dynamictp.common.util.ExtensionServiceLoader;

public final class ConfigHandler {
    private static final List<ConfigParser> PARSERS = Lists.newArrayList();

    private ConfigHandler() {
        List loadedParses = ExtensionServiceLoader.get(ConfigParser.class);
        if (CollectionUtils.isNotEmpty((Collection)loadedParses)) {
            PARSERS.addAll(loadedParses);
        }
        PARSERS.add((ConfigParser)new PropertiesConfigParser());
        PARSERS.add((ConfigParser)new YamlConfigParser());
        PARSERS.add((ConfigParser)new JsonConfigParser());
    }

    public Map<Object, Object> parseConfig(String content, ConfigFileTypeEnum type) throws IOException {
        for (ConfigParser parser : PARSERS) {
            if (!parser.supports(type)) continue;
            return parser.doParse(content);
        }
        return Collections.emptyMap();
    }

    public static ConfigHandler getInstance() {
        return ConfigHandlerHolder.INSTANCE;
    }

    private static class ConfigHandlerHolder {
        private static final ConfigHandler INSTANCE = new ConfigHandler();

        private ConfigHandlerHolder() {
        }
    }
}

