/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.common.entity.NotifyItem;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.entity.TpMainFields;
import org.dromara.dynamictp.common.notifier.DingNotifier;
import org.dromara.dynamictp.common.notifier.LarkNotifier;
import org.dromara.dynamictp.common.notifier.Notifier;
import org.dromara.dynamictp.common.notifier.WechatNotifier;
import org.dromara.dynamictp.common.util.ExtensionServiceLoader;
import org.dromara.dynamictp.core.notifier.DtpDingNotifier;
import org.dromara.dynamictp.core.notifier.DtpLarkNotifier;
import org.dromara.dynamictp.core.notifier.DtpNotifier;
import org.dromara.dynamictp.core.notifier.DtpWechatNotifier;
import org.dromara.dynamictp.core.notifier.context.DtpNotifyCtxHolder;
import org.dromara.dynamictp.core.notifier.manager.NotifyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotifierHandler {
    private static final Logger log = LoggerFactory.getLogger(NotifierHandler.class);
    private static final Map<String, DtpNotifier> NOTIFIERS = new HashMap<String, DtpNotifier>();

    private NotifierHandler() {
        List loadedNotifiers = ExtensionServiceLoader.get(DtpNotifier.class);
        loadedNotifiers.forEach(notifier -> NOTIFIERS.put(notifier.platform(), (DtpNotifier)notifier));
        DtpDingNotifier dingNotifier = new DtpDingNotifier((Notifier)new DingNotifier());
        DtpWechatNotifier wechatNotifier = new DtpWechatNotifier((Notifier)new WechatNotifier());
        DtpLarkNotifier larkNotifier = new DtpLarkNotifier((Notifier)new LarkNotifier());
        NOTIFIERS.put(dingNotifier.platform(), dingNotifier);
        NOTIFIERS.put(wechatNotifier.platform(), wechatNotifier);
        NOTIFIERS.put(larkNotifier.platform(), larkNotifier);
    }

    public void sendNotice(TpMainFields oldFields, List<String> diffs) {
        NotifyItem notifyItem = DtpNotifyCtxHolder.get().getNotifyItem();
        for (String platformId : notifyItem.getPlatformIds()) {
            NotifyHelper.getPlatform(platformId).ifPresent(p -> {
                DtpNotifier notifier = NOTIFIERS.get(p.getPlatform().toLowerCase());
                if (notifier != null) {
                    notifier.sendChangeMsg((NotifyPlatform)p, oldFields, diffs);
                }
            });
        }
    }

    public void sendAlarm(NotifyItemEnum notifyItemEnum) {
        NotifyItem notifyItem = DtpNotifyCtxHolder.get().getNotifyItem();
        for (String platformId : notifyItem.getPlatformIds()) {
            NotifyHelper.getPlatform(platformId).ifPresent(p -> {
                DtpNotifier notifier = NOTIFIERS.get(p.getPlatform().toLowerCase());
                if (notifier != null) {
                    notifier.sendAlarmMsg((NotifyPlatform)p, notifyItemEnum);
                }
            });
        }
    }

    public static NotifierHandler getInstance() {
        return NotifierHandlerHolder.INSTANCE;
    }

    private static class NotifierHandlerHolder {
        private static final NotifierHandler INSTANCE = new NotifierHandler();

        private NotifierHandlerHolder() {
        }
    }
}

