/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.metric;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformSnapshot;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class LimitedUniformReservoir
implements Reservoir {
    private static final int DEFAULT_SIZE = 4096;
    private static final int BITS_PER_LONG = 63;
    private final AtomicLong count = new AtomicLong();
    private volatile AtomicLongArray values = new AtomicLongArray(4096);

    public int size() {
        long c = this.count.get();
        if (c > (long)this.values.length()) {
            return this.values.length();
        }
        return (int)c;
    }

    public void update(long value) {
        long c = this.count.incrementAndGet();
        if (c <= (long)this.values.length()) {
            this.values.set((int)c - 1, value);
        } else {
            long r = LimitedUniformReservoir.nextLong(c);
            if (r < (long)this.values.length()) {
                this.values.set((int)r, value);
            }
        }
    }

    public Snapshot getSnapshot() {
        int s = this.size();
        ArrayList<Long> copy = new ArrayList<Long>(s);
        for (int i = 0; i < s; ++i) {
            copy.add(this.values.get(i));
        }
        return new UniformSnapshot(copy);
    }

    public void reset() {
        this.count.set(0L);
        this.values = new AtomicLongArray(4096);
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = ThreadLocalRandom.current().nextLong() & Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }
}

