/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.metric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.atomic.AtomicLong;
import org.dromara.dynamictp.core.metric.Summary;

public class MMACounter
implements Summary {
    private final AtomicLong total = new AtomicLong();
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);

    @Override
    public void add(long value) {
        this.total.addAndGet(value);
        this.count.incrementAndGet();
        this.setMin(value);
        this.setMax(value);
    }

    @Override
    public void reset() {
        this.total.set(0L);
        this.count.set(0L);
        this.min.set(Long.MAX_VALUE);
        this.max.set(Long.MIN_VALUE);
    }

    public long getTotal() {
        return this.total.get();
    }

    public long getCount() {
        return this.count.get();
    }

    public long getMin() {
        long current = this.min.get();
        return current == Long.MAX_VALUE ? 0L : current;
    }

    public long getMax() {
        long current = this.max.get();
        return current == Long.MIN_VALUE ? 0L : current;
    }

    public double getAvg() {
        long currentCount = this.count.get();
        long currentTotal = this.total.get();
        if (currentCount > 0L) {
            double avgLatency = (double)currentTotal / (double)currentCount;
            BigDecimal bg = new BigDecimal(avgLatency);
            return bg.setScale(4, RoundingMode.HALF_UP).doubleValue();
        }
        return 0.0;
    }

    private void setMax(long value) {
        long current;
        while (value > (current = this.max.get()) && !this.max.compareAndSet(current, value)) {
        }
    }

    private void setMin(long value) {
        long current;
        while (value < (current = this.min.get()) && !this.min.compareAndSet(current, value)) {
        }
    }
}

