/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.monitor;

import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.common.constant.DynamicTpConst;
import org.dromara.dynamictp.common.entity.ThreadPoolStats;
import org.dromara.dynamictp.common.event.AlarmCheckEvent;
import org.dromara.dynamictp.common.event.CollectEvent;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.spring.ApplicationContextHolder;
import org.dromara.dynamictp.common.spring.OnceApplicationContextEventListener;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.converter.ExecutorConverter;
import org.dromara.dynamictp.core.handler.CollectorHandler;
import org.dromara.dynamictp.core.notifier.manager.AlarmManager;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class DtpMonitor
extends OnceApplicationContextEventListener {
    private static final Logger log = LoggerFactory.getLogger(DtpMonitor.class);
    private static final ScheduledExecutorService MONITOR_EXECUTOR = ThreadPoolCreator.newScheduledThreadPool("dtp-monitor", 1);
    private final DtpProperties dtpProperties;
    private ScheduledFuture<?> monitorFuture;
    private int monitorInterval;

    public DtpMonitor(DtpProperties dtpProperties) {
        this.dtpProperties = dtpProperties;
    }

    protected synchronized void onContextRefreshedEvent(ContextRefreshedEvent event) {
        if (this.monitorInterval == this.dtpProperties.getMonitorInterval()) {
            return;
        }
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        this.monitorInterval = this.dtpProperties.getMonitorInterval();
        this.monitorFuture = MONITOR_EXECUTOR.scheduleWithFixedDelay(this::run, 0L, this.dtpProperties.getMonitorInterval(), TimeUnit.SECONDS);
    }

    private void run() {
        Set<String> executorNames = DtpRegistry.getAllExecutorNames();
        this.checkAlarm(executorNames);
        this.collectMetrics(executorNames);
    }

    private void checkAlarm(Set<String> executorNames) {
        executorNames.forEach(name -> {
            ExecutorWrapper wrapper = DtpRegistry.getExecutorWrapper(name);
            AlarmManager.tryAlarmAsync(wrapper, DynamicTpConst.SCHEDULE_NOTIFY_ITEMS);
        });
        this.publishAlarmCheckEvent();
    }

    private void collectMetrics(Set<String> executorNames) {
        if (!this.dtpProperties.isEnabledCollect()) {
            return;
        }
        executorNames.forEach(x -> {
            ExecutorWrapper wrapper = DtpRegistry.getExecutorWrapper(x);
            this.doCollect(ExecutorConverter.toMetrics(wrapper));
        });
        this.publishCollectEvent();
    }

    private void doCollect(ThreadPoolStats threadPoolStats) {
        try {
            CollectorHandler.getInstance().collect(threadPoolStats, this.dtpProperties.getCollectorTypes());
        }
        catch (Exception e) {
            log.error("DynamicTp monitor, metrics collect error.", (Throwable)e);
        }
    }

    private void publishCollectEvent() {
        CollectEvent event = new CollectEvent((Object)this, this.dtpProperties);
        ApplicationContextHolder.publishEvent((ApplicationEvent)event);
    }

    private void publishAlarmCheckEvent() {
        AlarmCheckEvent event = new AlarmCheckEvent((Object)this, this.dtpProperties);
        ApplicationContextHolder.publishEvent((ApplicationEvent)event);
    }

    public static void destroy() {
        MONITOR_EXECUTOR.shutdownNow();
    }
}

