/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.monitor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.atomic.AtomicLong;
import org.dromara.dynamictp.core.metric.MMAPCounter;

public class PerformanceProvider {
    private final AtomicLong lastRefreshMillis = new AtomicLong(System.currentTimeMillis());
    private final MMAPCounter mmapCounter = new MMAPCounter();

    public void completeTask(long rt) {
        this.mmapCounter.add(rt);
    }

    public PerformanceSnapshot getSnapshotAndReset() {
        long currentMillis = System.currentTimeMillis();
        int intervalTs = (int)(currentMillis - this.lastRefreshMillis.get()) / 1000;
        PerformanceSnapshot performanceSnapshot = new PerformanceSnapshot(this.mmapCounter, intervalTs);
        this.reset(currentMillis);
        return performanceSnapshot;
    }

    private void reset(long currentMillis) {
        this.mmapCounter.reset();
        this.lastRefreshMillis.compareAndSet(this.lastRefreshMillis.get(), currentMillis);
    }

    public static class PerformanceSnapshot {
        private final double tps;
        private final long maxRt;
        private final long minRt;
        private final double avg;
        private final double tp50;
        private final double tp75;
        private final double tp90;
        private final double tp95;
        private final double tp99;
        private final double tp999;

        public PerformanceSnapshot(MMAPCounter mmapCounter, int monitorInterval) {
            this.tps = BigDecimal.valueOf(mmapCounter.getMmaCounter().getCount()).divide(BigDecimal.valueOf(Math.max(monitorInterval, 1)), 1, RoundingMode.HALF_UP).doubleValue();
            this.maxRt = mmapCounter.getMmaCounter().getMax();
            this.minRt = mmapCounter.getMmaCounter().getMin();
            this.avg = mmapCounter.getMmaCounter().getAvg();
            this.tp50 = mmapCounter.getSnapshot().getMedian();
            this.tp75 = mmapCounter.getSnapshot().get75thPercentile();
            this.tp90 = mmapCounter.getSnapshot().getValue(0.9);
            this.tp95 = mmapCounter.getSnapshot().get95thPercentile();
            this.tp99 = mmapCounter.getSnapshot().get99thPercentile();
            this.tp999 = mmapCounter.getSnapshot().get999thPercentile();
        }

        public double getTps() {
            return this.tps;
        }

        public long getMaxRt() {
            return this.maxRt;
        }

        public long getMinRt() {
            return this.minRt;
        }

        public double getAvg() {
            return this.avg;
        }

        public double getTp50() {
            return this.tp50;
        }

        public double getTp75() {
            return this.tp75;
        }

        public double getTp90() {
            return this.tp90;
        }

        public double getTp95() {
            return this.tp95;
        }

        public double getTp99() {
            return this.tp99;
        }

        public double getTp999() {
            return this.tp999;
        }
    }
}

