/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.monitor.collector;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.dynamictp.common.em.CollectorTypeEnum;
import org.dromara.dynamictp.common.entity.ThreadPoolStats;
import org.dromara.dynamictp.common.util.CommonUtil;
import org.dromara.dynamictp.core.monitor.collector.AbstractCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class MicroMeterCollector
extends AbstractCollector {
    private static final Logger log = LoggerFactory.getLogger(MicroMeterCollector.class);
    public static final String DTP_METRIC_NAME_PREFIX = "thread.pool";
    public static final String POOL_NAME_TAG = "thread.pool.name";
    public static final String POOL_ALIAS_TAG = "thread.pool.alias";
    public static final String APP_NAME_TAG = "app.name";
    private static final Map<String, ThreadPoolStats> GAUGE_CACHE = new ConcurrentHashMap<String, ThreadPoolStats>();

    @Override
    public void collect(ThreadPoolStats threadPoolStats) {
        ThreadPoolStats oldStats = GAUGE_CACHE.get(threadPoolStats.getPoolName());
        if (Objects.isNull(oldStats)) {
            GAUGE_CACHE.put(threadPoolStats.getPoolName(), threadPoolStats);
        } else {
            BeanUtils.copyProperties((Object)threadPoolStats, (Object)oldStats);
        }
        this.gauge(GAUGE_CACHE.get(threadPoolStats.getPoolName()));
    }

    @Override
    public String type() {
        return CollectorTypeEnum.MICROMETER.name().toLowerCase();
    }

    public void gauge(ThreadPoolStats poolStats) {
        Iterable<Tag> tags = this.getTags(poolStats);
        Metrics.gauge((String)MicroMeterCollector.metricName("core.size"), tags, (Object)poolStats, ThreadPoolStats::getCorePoolSize);
        Metrics.gauge((String)MicroMeterCollector.metricName("maximum.size"), tags, (Object)poolStats, ThreadPoolStats::getMaximumPoolSize);
        Metrics.gauge((String)MicroMeterCollector.metricName("current.size"), tags, (Object)poolStats, ThreadPoolStats::getPoolSize);
        Metrics.gauge((String)MicroMeterCollector.metricName("largest.size"), tags, (Object)poolStats, ThreadPoolStats::getLargestPoolSize);
        Metrics.gauge((String)MicroMeterCollector.metricName("active.count"), tags, (Object)poolStats, ThreadPoolStats::getActiveCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("task.count"), tags, (Object)poolStats, ThreadPoolStats::getTaskCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.count"), tags, (Object)poolStats, ThreadPoolStats::getCompletedTaskCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("wait.task.count"), tags, (Object)poolStats, ThreadPoolStats::getWaitTaskCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("queue.size"), tags, (Object)poolStats, ThreadPoolStats::getQueueSize);
        Metrics.gauge((String)MicroMeterCollector.metricName("queue.capacity"), tags, (Object)poolStats, ThreadPoolStats::getQueueCapacity);
        Metrics.gauge((String)MicroMeterCollector.metricName("queue.remaining.capacity"), tags, (Object)poolStats, ThreadPoolStats::getQueueRemainingCapacity);
        Metrics.gauge((String)MicroMeterCollector.metricName("reject.count"), tags, (Object)poolStats, ThreadPoolStats::getRejectCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("run.timeout.count"), tags, (Object)poolStats, ThreadPoolStats::getRunTimeoutCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("queue.timeout.count"), tags, (Object)poolStats, ThreadPoolStats::getQueueTimeoutCount);
        Metrics.gauge((String)MicroMeterCollector.metricName("tps"), tags, (Object)poolStats, ThreadPoolStats::getTps);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.time.avg"), tags, (Object)poolStats, ThreadPoolStats::getAvg);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.time.max"), tags, (Object)poolStats, ThreadPoolStats::getMaxRt);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.time.min"), tags, (Object)poolStats, ThreadPoolStats::getMinRt);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.time.tp50"), tags, (Object)poolStats, ThreadPoolStats::getTp50);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.time.tp75"), tags, (Object)poolStats, ThreadPoolStats::getTp75);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.time.tp90"), tags, (Object)poolStats, ThreadPoolStats::getTp90);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.time.tp95"), tags, (Object)poolStats, ThreadPoolStats::getTp95);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.time.tp99"), tags, (Object)poolStats, ThreadPoolStats::getTp99);
        Metrics.gauge((String)MicroMeterCollector.metricName("completed.task.time.tp999"), tags, (Object)poolStats, ThreadPoolStats::getTp999);
    }

    private static String metricName(String name) {
        return String.join((CharSequence)".", DTP_METRIC_NAME_PREFIX, name);
    }

    private Iterable<Tag> getTags(ThreadPoolStats poolStats) {
        ArrayList<Tag> tags = new ArrayList<Tag>(3);
        tags.add(Tag.of((String)POOL_NAME_TAG, (String)poolStats.getPoolName()));
        tags.add(Tag.of((String)APP_NAME_TAG, (String)CommonUtil.getInstance().getServiceName()));
        tags.add(Tag.of((String)POOL_ALIAS_TAG, (String)Optional.ofNullable(poolStats.getPoolAliasName()).orElse(poolStats.getPoolName())));
        return tags;
    }
}

