/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.monitor.collector.jmx;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.dromara.dynamictp.common.em.CollectorTypeEnum;
import org.dromara.dynamictp.common.entity.ThreadPoolStats;
import org.dromara.dynamictp.core.monitor.collector.AbstractCollector;
import org.dromara.dynamictp.core.monitor.collector.jmx.ThreadPoolStatsJMX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class JMXCollector
extends AbstractCollector {
    private static final Logger log = LoggerFactory.getLogger(JMXCollector.class);
    public static final String DTP_METRIC_NAME_PREFIX = "dtp.thread.pool";
    private static final Map<String, ThreadPoolStats> GAUGE_CACHE = new ConcurrentHashMap<String, ThreadPoolStats>();

    @Override
    public void collect(ThreadPoolStats threadPoolStats) {
        if (GAUGE_CACHE.containsKey(threadPoolStats.getPoolName())) {
            ThreadPoolStats poolStats = GAUGE_CACHE.get(threadPoolStats.getPoolName());
            BeanUtils.copyProperties((Object)threadPoolStats, (Object)poolStats);
        } else {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName name = new ObjectName("dtp.thread.pool:name=" + threadPoolStats.getPoolName());
                ThreadPoolStatsJMX stats = new ThreadPoolStatsJMX(threadPoolStats);
                server.registerMBean(stats, name);
            }
            catch (JMException e) {
                log.error("collect thread pool stats error", (Throwable)e);
            }
            GAUGE_CACHE.put(threadPoolStats.getPoolName(), threadPoolStats);
        }
    }

    @Override
    public String type() {
        return CollectorTypeEnum.JMX.name().toLowerCase();
    }
}

