/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.notifier;

import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.common.entity.AlarmInfo;
import org.dromara.dynamictp.common.entity.NotifyItem;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.entity.TpMainFields;
import org.dromara.dynamictp.common.notifier.Notifier;
import org.dromara.dynamictp.common.util.CommonUtil;
import org.dromara.dynamictp.common.util.DateUtil;
import org.dromara.dynamictp.core.notifier.DtpNotifier;
import org.dromara.dynamictp.core.notifier.alarm.AlarmCounter;
import org.dromara.dynamictp.core.notifier.context.AlarmCtx;
import org.dromara.dynamictp.core.notifier.context.BaseNotifyCtx;
import org.dromara.dynamictp.core.notifier.context.DtpNotifyCtxHolder;
import org.dromara.dynamictp.core.notifier.manager.NotifyHelper;
import org.dromara.dynamictp.core.support.ExecutorAdapter;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolStatProvider;
import org.dromara.dynamictp.core.system.SystemMetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;

public abstract class AbstractDtpNotifier
implements DtpNotifier {
    private static final Logger log = LoggerFactory.getLogger(AbstractDtpNotifier.class);
    protected Notifier notifier;

    protected AbstractDtpNotifier() {
    }

    protected AbstractDtpNotifier(Notifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public void sendChangeMsg(NotifyPlatform notifyPlatform, TpMainFields oldFields, List<String> diffs) {
        String content = this.buildNoticeContent(notifyPlatform, oldFields, diffs);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug("Notice content is empty, ignore send notice message.");
            return;
        }
        this.notifier.send(this.newTargetPlatform(notifyPlatform), content);
    }

    @Override
    public void sendAlarmMsg(NotifyPlatform notifyPlatform, NotifyItemEnum notifyItemEnum) {
        String content = this.buildAlarmContent(notifyPlatform, notifyItemEnum);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug("Alarm content is empty, ignore send alarm message.");
            return;
        }
        this.notifier.send(this.newTargetPlatform(notifyPlatform), content);
    }

    protected String buildAlarmContent(NotifyPlatform platform, NotifyItemEnum notifyItemEnum) {
        AlarmCtx context = (AlarmCtx)DtpNotifyCtxHolder.get();
        ExecutorWrapper executorWrapper = context.getExecutorWrapper();
        ExecutorAdapter<?> executor = executorWrapper.getExecutor();
        NotifyItem notifyItem = context.getNotifyItem();
        ThreadPoolStatProvider statProvider = executorWrapper.getThreadPoolStatProvider();
        String alarmValue = notifyItem.getThreshold() + notifyItemEnum.getUnit() + " / " + AlarmCounter.calcCurrentValue(executorWrapper, notifyItemEnum) + notifyItemEnum.getUnit();
        String content = String.format(this.getAlarmTemplate(), CommonUtil.getInstance().getServiceName(), CommonUtil.getInstance().getIp() + ":" + CommonUtil.getInstance().getPort(), CommonUtil.getInstance().getEnv(), this.populatePoolName(executorWrapper), this.populateAlarmItem(notifyItemEnum, executorWrapper), alarmValue, executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getPoolSize(), executor.getActiveCount(), executor.getLargestPoolSize(), executor.getTaskCount(), executor.getCompletedTaskCount(), executor.getQueueSize(), executor.getQueueType(), executor.getQueueCapacity(), executor.getQueueSize(), executor.getQueueRemainingCapacity(), executor.getRejectHandlerType(), statProvider.getRejectedTaskCount(), statProvider.getRunTimeoutCount(), statProvider.getQueueTimeoutCount(), Optional.ofNullable(context.getAlarmInfo()).map(AlarmInfo::getLastAlarmTime).orElse("---"), DateUtil.now(), this.getReceives(notifyItem, platform), this.getTraceInfo(), notifyItem.getInterval(), this.getExtInfo());
        return this.highlightAlarmContent(content, notifyItemEnum);
    }

    protected String buildNoticeContent(NotifyPlatform platform, TpMainFields oldFields, List<String> diffs) {
        BaseNotifyCtx context = DtpNotifyCtxHolder.get();
        ExecutorWrapper executorWrapper = context.getExecutorWrapper();
        ExecutorAdapter<?> executor = executorWrapper.getExecutor();
        String content = String.format(this.getNoticeTemplate(), CommonUtil.getInstance().getServiceName(), CommonUtil.getInstance().getIp() + ":" + CommonUtil.getInstance().getPort(), CommonUtil.getInstance().getEnv(), this.populatePoolName(executorWrapper), oldFields.getCorePoolSize(), executor.getCorePoolSize(), oldFields.getMaxPoolSize(), executor.getMaximumPoolSize(), oldFields.isAllowCoreThreadTimeOut(), executor.allowsCoreThreadTimeOut(), oldFields.getKeepAliveTime(), executor.getKeepAliveTime(TimeUnit.SECONDS), executor.getQueueType(), oldFields.getQueueCapacity(), executor.getQueueCapacity(), oldFields.getRejectType(), executor.getRejectHandlerType(), this.getReceives(context.getNotifyItem(), platform), DateUtil.now());
        return this.highlightNotifyContent(content, diffs);
    }

    protected String getTraceInfo() {
        String tid = MDC.get((String)"traceId");
        if (StringUtils.isBlank((CharSequence)tid)) {
            return "---";
        }
        return tid;
    }

    protected String getExtInfo() {
        return SystemMetricManager.getSystemMetric();
    }

    protected String getReceives(NotifyItem notifyItem, NotifyPlatform platform) {
        String receives;
        String string = receives = StringUtils.isBlank((CharSequence)notifyItem.getReceivers()) ? platform.getReceivers() : notifyItem.getReceivers();
        if (StringUtils.isBlank((CharSequence)receives)) {
            return "";
        }
        return this.formatReceivers(receives);
    }

    protected String formatReceivers(String receives) {
        Object[] receivers = StringUtils.split((String)receives, (char)',');
        return Joiner.on((String)", @").join(receivers);
    }

    private NotifyPlatform newTargetPlatform(NotifyPlatform platform) {
        NotifyPlatform targetPlatform = new NotifyPlatform();
        BeanUtils.copyProperties((Object)platform, (Object)targetPlatform);
        BaseNotifyCtx context = DtpNotifyCtxHolder.get();
        NotifyItem item = context.getNotifyItem();
        String receives = StringUtils.isBlank((CharSequence)item.getReceivers()) ? platform.getReceivers() : item.getReceivers();
        targetPlatform.setReceivers(receives);
        return targetPlatform;
    }

    protected String populatePoolName(ExecutorWrapper executorWrapper) {
        String poolAlisaName = executorWrapper.getThreadPoolAliasName();
        if (StringUtils.isBlank((CharSequence)poolAlisaName)) {
            return executorWrapper.getThreadPoolName();
        }
        return executorWrapper.getThreadPoolName() + " (" + poolAlisaName + ")";
    }

    protected String populateAlarmItem(NotifyItemEnum notifyType, ExecutorWrapper executorWrapper) {
        String suffix = "";
        if (notifyType == NotifyItemEnum.RUN_TIMEOUT) {
            suffix = " (" + executorWrapper.getThreadPoolStatProvider().getRunTimeout() + "ms)";
        } else if (notifyType == NotifyItemEnum.QUEUE_TIMEOUT) {
            suffix = " (" + executorWrapper.getThreadPoolStatProvider().getQueueTimeout() + "ms)";
        }
        return notifyType.getValue() + suffix;
    }

    private String highlightNotifyContent(String content, List<String> diffs) {
        if (StringUtils.isBlank((CharSequence)content) || Objects.isNull(this.getColors())) {
            return content;
        }
        Pair<String, String> pair = this.getColors();
        for (String string : diffs) {
            content = content.replace(string, (CharSequence)pair.getLeft());
        }
        for (Field field : TpMainFields.getMainFields()) {
            content = content.replace(field.getName(), (CharSequence)pair.getRight());
        }
        return content;
    }

    private String highlightAlarmContent(String content, NotifyItemEnum notifyItemEnum) {
        if (StringUtils.isBlank((CharSequence)content) || Objects.isNull(this.getColors())) {
            return content;
        }
        Set<String> colorKeys = NotifyHelper.getAlarmKeys(notifyItemEnum);
        Pair<String, String> pair = this.getColors();
        for (String field : colorKeys) {
            content = content.replace(field, (CharSequence)pair.getLeft());
        }
        for (String field : NotifyHelper.getAllAlarmKeys()) {
            content = content.replace(field, (CharSequence)pair.getRight());
        }
        return content;
    }

    protected abstract String getNoticeTemplate();

    protected abstract String getAlarmTemplate();

    protected abstract Pair<String, String> getColors();
}

