/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.notifier;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.dromara.dynamictp.common.em.NotifyPlatformEnum;
import org.dromara.dynamictp.common.notifier.Notifier;
import org.dromara.dynamictp.core.notifier.AbstractDtpNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtpWechatNotifier
extends AbstractDtpNotifier {
    private static final Logger log = LoggerFactory.getLogger(DtpWechatNotifier.class);

    public DtpWechatNotifier(Notifier notifier) {
        super(notifier);
    }

    @Override
    public String platform() {
        return NotifyPlatformEnum.WECHAT.name().toLowerCase();
    }

    @Override
    protected String getNoticeTemplate() {
        return "<font color='info'>\u3010\u901a\u77e5\u3011</font> \u52a8\u6001\u7ebf\u7a0b\u6c60\u53c2\u6570\u53d8\u66f4 \n> <font color='comment'>\u670d\u52a1\u540d\u79f0\uff1a%s</font> \n> <font color='comment'>\u5b9e\u4f8b\u4fe1\u606f\uff1a%s</font> \n> <font color='comment'>\u73af\u5883\uff1a%s</font> \n> <font color='comment'>\u7ebf\u7a0b\u6c60\u540d\u79f0\uff1a%s</font> \n> <font color='corePoolSize'>\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a%s => %s</font> \n> <font color='maxPoolSize'>\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%s => %s</font> \n> <font color='allowCoreThreadTimeOut'>\u5141\u8bb8\u6838\u5fc3\u7ebf\u7a0b\u8d85\u65f6\uff1a%s => %s</font> \n> <font color='keepAliveTime'>\u7ebf\u7a0b\u5b58\u6d3b\u65f6\u95f4\uff1a%ss => %ss</font> \n> <font color='comment'>\u961f\u5217\u7c7b\u578b\uff1a%s</font> \n> <font color='queueCapacity'>\u961f\u5217\u5bb9\u91cf\uff1a%s => %s</font> \n> <font color='rejectType'>\u62d2\u7edd\u7b56\u7565\uff1a%s => %s</font> \n> <font color='comment'>\u63a5\u6536\u4eba\uff1a%s</font> \n> <font color='comment'>\u901a\u77e5\u65f6\u95f4\uff1a%s</font> \n";
    }

    @Override
    protected String getAlarmTemplate() {
        return "<font color='warning'>\u3010\u62a5\u8b66\u3011</font> \u52a8\u6001\u7ebf\u7a0b\u6c60\u544a\u8b66 \n> <font color='comment'>\u670d\u52a1\u540d\u79f0\uff1a%s</font> \n> <font color='comment'>\u5b9e\u4f8b\u4fe1\u606f\uff1a%s</font> \n> <font color='comment'>\u73af\u5883\uff1a%s</font> \n> <font color='comment'>\u7ebf\u7a0b\u6c60\u540d\u79f0\uff1a%s</font> \n> <font color='alarmType'>\u62a5\u8b66\u9879\uff1a%s</font> \n> <font color='alarmValue'>\u62a5\u8b66\u9608\u503c / \u5f53\u524d\u503c\uff1a%s</font> \n> <font color='corePoolSize'>\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a%s</font> \n> <font color='maximumPoolSize'>\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%s</font> \n> <font color='poolSize'>\u5f53\u524d\u7ebf\u7a0b\u6570\uff1a%s</font> \n> <font color='activeCount'>\u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a%s</font> \n> <font color='comment'>\u5386\u53f2\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%s</font> \n> <font color='comment'>\u4efb\u52a1\u603b\u6570\uff1a%s</font> \n> <font color='comment'>\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6570\uff1a%s</font> \n> <font color='comment'>\u7b49\u5f85\u6267\u884c\u4efb\u52a1\u6570\uff1a%s</font> \n> <font color='queueType'>\u961f\u5217\u7c7b\u578b\uff1a%s</font> \n> <font color='queueCapacity'>\u961f\u5217\u5bb9\u91cf\uff1a%s</font> \n> <font color='queueSize'>\u961f\u5217\u4efb\u52a1\u6570\u91cf\uff1a%s</font> \n> <font color='queueRemaining'>\u961f\u5217\u5269\u4f59\u5bb9\u91cf\uff1a%s</font> \n> <font color='rejectType'>\u62d2\u7edd\u7b56\u7565\uff1a%s</font> \n> <font color='rejectCount'>\u603b\u62d2\u7edd\u4efb\u52a1\u6570\u91cf\uff1a%s</font> \n> <font color='runTimeoutCount'>\u603b\u6267\u884c\u8d85\u65f6\u4efb\u52a1\u6570\u91cf\uff1a%s</font> \n> <font color='queueTimeoutCount'>\u603b\u7b49\u5f85\u8d85\u65f6\u4efb\u52a1\u6570\u91cf\uff1a%s</font> \n> <font color='comment'>\u4e0a\u6b21\u62a5\u8b66\u65f6\u95f4\uff1a%s</font> \n> <font color='comment'>\u62a5\u8b66\u65f6\u95f4\uff1a%s</font> \n> <font color='comment'>\u63a5\u6536\u4eba\uff1a%s</font> \n> <font color='comment'>trace \u4fe1\u606f\uff1a%s</font> \n> <font color='info'>\u62a5\u8b66\u95f4\u9694\uff1a%ss</font> \n> <font color='comment'>\u6269\u5c55\u4fe1\u606f\uff1a%s</font> \n";
    }

    @Override
    protected Pair<String, String> getColors() {
        return new ImmutablePair((Object)"warning", (Object)"comment");
    }

    @Override
    protected String formatReceivers(String receives) {
        return Arrays.stream(StringUtils.split((String)receives, (char)',')).map(receiver -> "<@" + receiver + ">").collect(Collectors.joining(","));
    }
}

