/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.notifier.alarm;

import cn.hutool.core.util.NumberUtil;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.common.entity.AlarmInfo;
import org.dromara.dynamictp.core.support.ExecutorAdapter;
import org.dromara.dynamictp.core.support.ExecutorWrapper;

public class AlarmCounter {
    private static final Map<String, AlarmInfo> ALARM_INFO_CACHE = new ConcurrentHashMap<String, AlarmInfo>();

    private AlarmCounter() {
    }

    public static void init(String threadPoolName, String notifyItemType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyItemType);
        AlarmInfo alarmInfo = new AlarmInfo().setNotifyItem(NotifyItemEnum.of((String)notifyItemType));
        ALARM_INFO_CACHE.putIfAbsent(key, alarmInfo);
    }

    public static AlarmInfo getAlarmInfo(String threadPoolName, String notifyItemType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyItemType);
        return ALARM_INFO_CACHE.get(key);
    }

    public static String getCount(String threadPoolName, String notifyItemType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyItemType);
        AlarmInfo alarmInfo = ALARM_INFO_CACHE.get(key);
        if (Objects.nonNull(alarmInfo)) {
            return String.valueOf(alarmInfo.getCount());
        }
        return "---";
    }

    public static void reset(String threadPoolName, String notifyItemType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyItemType);
        AlarmInfo alarmInfo = ALARM_INFO_CACHE.get(key);
        alarmInfo.reset();
    }

    public static void incAlarmCounter(String threadPoolName, String notifyItemType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyItemType);
        AlarmInfo alarmInfo = ALARM_INFO_CACHE.get(key);
        if (Objects.nonNull(alarmInfo)) {
            alarmInfo.incCounter();
        }
    }

    public static int calcCurrentValue(ExecutorWrapper wrapper, NotifyItemEnum itemEnum) {
        ExecutorAdapter<?> executor = wrapper.getExecutor();
        switch (itemEnum) {
            case CAPACITY: {
                return (int)(NumberUtil.div((float)executor.getQueueSize(), (float)executor.getQueueCapacity(), (int)2) * 100.0);
            }
            case LIVENESS: {
                return (int)(NumberUtil.div((float)executor.getActiveCount(), (float)executor.getMaximumPoolSize(), (int)2) * 100.0);
            }
            case REJECT: 
            case RUN_TIMEOUT: 
            case QUEUE_TIMEOUT: {
                return Integer.parseInt(AlarmCounter.getCount(wrapper.getThreadPoolName(), itemEnum.getValue()));
            }
        }
        return 0;
    }

    private static String buildKey(String threadPoolName, String notifyItemType) {
        return threadPoolName + ":" + notifyItemType;
    }
}

