/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.notifier.alarm;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.common.entity.NotifyItem;

public class AlarmLimiter {
    private static final Map<String, Cache<String, String>> ALARM_LIMITER = new ConcurrentHashMap<String, Cache<String, String>>();

    private AlarmLimiter() {
    }

    public static void initAlarmLimiter(String threadPoolName, NotifyItem notifyItem) {
        if (NotifyItemEnum.CHANGE.getValue().equalsIgnoreCase(notifyItem.getType())) {
            return;
        }
        String key = AlarmLimiter.genKey(threadPoolName, notifyItem.getType());
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite((long)notifyItem.getInterval(), TimeUnit.SECONDS).build();
        ALARM_LIMITER.put(key, (Cache<String, String>)cache);
    }

    public static void putVal(String threadPoolName, String type) {
        String key = AlarmLimiter.genKey(threadPoolName, type);
        ALARM_LIMITER.get(key).put((Object)type, (Object)type);
    }

    public static String getAlarmLimitInfo(String key, String type) {
        Cache<String, String> cache = ALARM_LIMITER.get(key);
        if (Objects.isNull(cache)) {
            return null;
        }
        return (String)cache.getIfPresent((Object)type);
    }

    public static boolean ifAlarm(String threadPoolName, String type) {
        String key = AlarmLimiter.genKey(threadPoolName, type);
        return StringUtils.isBlank((CharSequence)AlarmLimiter.getAlarmLimitInfo(key, type));
    }

    public static String genKey(String threadPoolName, String type) {
        return threadPoolName + ":" + type;
    }
}

