/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.notifier.capture;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.core.notifier.capture.CapturedBlockingQueue;
import org.dromara.dynamictp.core.support.ExecutorAdapter;

public final class CapturedExecutor
implements ExecutorAdapter<ExecutorAdapter<?>> {
    private final ExecutorAdapter<?> originExecutor;
    private final int corePoolSize;
    private final int maximumPoolSize;
    private final int activeCount;
    private final int poolSize;
    private final int largestPoolSize;
    private final long taskCount;
    private final long completedTaskCount;
    private final long keepAliveTime;
    private final boolean allowCoreThreadTimeOut;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private final String rejectHandlerType;
    private final CapturedBlockingQueue blockingQueue;

    public CapturedExecutor(ExecutorAdapter<?> executorAdapter) {
        this.originExecutor = executorAdapter;
        this.corePoolSize = executorAdapter.getCorePoolSize();
        this.maximumPoolSize = executorAdapter.getMaximumPoolSize();
        this.activeCount = executorAdapter.getActiveCount();
        this.poolSize = executorAdapter.getPoolSize();
        this.largestPoolSize = executorAdapter.getLargestPoolSize();
        this.taskCount = executorAdapter.getTaskCount();
        this.completedTaskCount = executorAdapter.getCompletedTaskCount();
        this.keepAliveTime = executorAdapter.getKeepAliveTime(TimeUnit.SECONDS);
        this.allowCoreThreadTimeOut = executorAdapter.allowsCoreThreadTimeOut();
        this.rejectedExecutionHandler = executorAdapter.getRejectedExecutionHandler();
        this.rejectHandlerType = executorAdapter.getRejectHandlerType();
        this.blockingQueue = new CapturedBlockingQueue(executorAdapter);
    }

    @Override
    public ExecutorAdapter<?> getOriginal() {
        return this.originExecutor;
    }

    @Override
    public void execute(Runnable command) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public int getActiveCount() {
        return this.activeCount;
    }

    @Override
    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    @Override
    public long getTaskCount() {
        return this.taskCount;
    }

    @Override
    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.blockingQueue;
    }

    @Override
    public String getQueueType() {
        return this.blockingQueue.getQueueType();
    }

    @Override
    public int getQueueSize() {
        return this.blockingQueue.size();
    }

    @Override
    public int getQueueRemainingCapacity() {
        return this.blockingQueue.remainingCapacity();
    }

    @Override
    public int getQueueCapacity() {
        return this.blockingQueue.getQueueCapacity();
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRejectHandlerType() {
        return this.rejectHandlerType;
    }

    @Override
    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.SECONDS);
    }

    @Override
    public void setKeepAliveTime(long time, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }
}

