/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.notifier.chain.filter;

import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.common.entity.NotifyItem;
import org.dromara.dynamictp.common.pattern.filter.Invoker;
import org.dromara.dynamictp.core.notifier.chain.filter.NotifyFilter;
import org.dromara.dynamictp.core.notifier.context.BaseNotifyCtx;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeBaseFilter
implements NotifyFilter {
    private static final Logger log = LoggerFactory.getLogger(NoticeBaseFilter.class);

    public void doFilter(BaseNotifyCtx context, Invoker<BaseNotifyCtx> nextInvoker) {
        ExecutorWrapper executorWrapper = context.getExecutorWrapper();
        NotifyItem notifyItem = context.getNotifyItem();
        if (Objects.isNull(notifyItem) || !this.satisfyBaseCondition(notifyItem, executorWrapper)) {
            log.debug("DynamicTp notify, no platforms configured or notification is not enabled, threadPoolName: {}", (Object)executorWrapper.getThreadPoolName());
            return;
        }
        nextInvoker.invoke((Object)context);
    }

    private boolean satisfyBaseCondition(NotifyItem notifyItem, ExecutorWrapper executor) {
        return executor.isNotifyEnabled() && notifyItem.isEnabled() && CollectionUtils.isNotEmpty((Collection)notifyItem.getPlatformIds());
    }

    public int getOrder() {
        return 0;
    }
}

