/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.notifier.manager;

import cn.hutool.core.util.NumberUtil;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.common.em.QueueTypeEnum;
import org.dromara.dynamictp.common.em.RejectedTypeEnum;
import org.dromara.dynamictp.common.entity.AlarmInfo;
import org.dromara.dynamictp.common.entity.NotifyItem;
import org.dromara.dynamictp.common.pattern.filter.InvokerChain;
import org.dromara.dynamictp.core.notifier.alarm.AlarmCounter;
import org.dromara.dynamictp.core.notifier.alarm.AlarmLimiter;
import org.dromara.dynamictp.core.notifier.context.AlarmCtx;
import org.dromara.dynamictp.core.notifier.context.BaseNotifyCtx;
import org.dromara.dynamictp.core.notifier.manager.NotifyFilterBuilder;
import org.dromara.dynamictp.core.notifier.manager.NotifyHelper;
import org.dromara.dynamictp.core.support.ExecutorAdapter;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;
import org.dromara.dynamictp.core.support.task.runnable.DtpRunnable;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AlarmManager {
    private static final Logger log = LoggerFactory.getLogger(AlarmManager.class);
    private static final ExecutorService ALARM_EXECUTOR = ThreadPoolBuilder.newBuilder().threadFactory("dtp-alarm").corePoolSize(1).maximumPoolSize(1).workQueue(QueueTypeEnum.LINKED_BLOCKING_QUEUE.getName(), 2000).rejectedExecutionHandler(RejectedTypeEnum.DISCARD_OLDEST_POLICY.getName()).rejectEnhanced(false).taskWrappers(TaskWrappers.getInstance().getByNames(Sets.newHashSet((Object[])new String[]{"mdc"}))).buildDynamic();
    private static final InvokerChain<BaseNotifyCtx> ALARM_INVOKER_CHAIN = NotifyFilterBuilder.getAlarmInvokerChain();

    private AlarmManager() {
    }

    public static void initAlarm(String poolName, List<NotifyItem> notifyItems) {
        notifyItems.forEach(x -> AlarmManager.initAlarm(poolName, x));
    }

    public static void initAlarm(String poolName, NotifyItem notifyItem) {
        AlarmLimiter.initAlarmLimiter(poolName, notifyItem);
        AlarmCounter.init(poolName, notifyItem.getType());
    }

    public static void tryAlarmAsync(ExecutorWrapper executorWrapper, NotifyItemEnum notifyType, Runnable runnable) {
        AlarmManager.preAlarm(runnable);
        try {
            ALARM_EXECUTOR.execute(() -> AlarmManager.doTryAlarm(executorWrapper, notifyType));
        }
        finally {
            AlarmManager.postAlarm(runnable);
        }
    }

    public static void tryAlarmAsync(ExecutorWrapper executorWrapper, List<NotifyItemEnum> notifyTypes) {
        ALARM_EXECUTOR.execute(() -> notifyTypes.forEach(x -> AlarmManager.doTryAlarm(executorWrapper, x)));
    }

    public static void doTryAlarm(ExecutorWrapper executorWrapper, NotifyItemEnum notifyType) {
        AlarmCounter.incAlarmCounter(executorWrapper.getThreadPoolName(), notifyType.getValue());
        NotifyHelper.getNotifyItem(executorWrapper, notifyType).ifPresent(notifyItem -> {
            AlarmCtx alarmCtx = new AlarmCtx(executorWrapper, (NotifyItem)notifyItem);
            ALARM_INVOKER_CHAIN.proceed((Object)alarmCtx);
        });
    }

    public static boolean checkThreshold(ExecutorWrapper executor, NotifyItemEnum notifyType, NotifyItem notifyItem) {
        switch (notifyType) {
            case CAPACITY: {
                return AlarmManager.checkCapacity(executor, notifyItem);
            }
            case LIVENESS: {
                return AlarmManager.checkLiveness(executor, notifyItem);
            }
            case REJECT: 
            case RUN_TIMEOUT: 
            case QUEUE_TIMEOUT: {
                return AlarmManager.checkWithAlarmInfo(executor, notifyItem);
            }
        }
        log.error("Unsupported alarm type [{}]", (Object)notifyType);
        return false;
    }

    public static void destroy() {
        ALARM_EXECUTOR.shutdownNow();
    }

    private static boolean checkLiveness(ExecutorWrapper executorWrapper, NotifyItem notifyItem) {
        ExecutorAdapter<?> executor = executorWrapper.getExecutor();
        int maximumPoolSize = executor.getMaximumPoolSize();
        double div = NumberUtil.div((float)executor.getActiveCount(), (float)maximumPoolSize, (int)2) * 100.0;
        return div >= (double)notifyItem.getThreshold();
    }

    private static boolean checkCapacity(ExecutorWrapper executorWrapper, NotifyItem notifyItem) {
        ExecutorAdapter<?> executor = executorWrapper.getExecutor();
        if (executor.getQueueSize() <= 0) {
            return false;
        }
        double div = NumberUtil.div((float)executor.getQueueSize(), (float)executor.getQueueCapacity(), (int)2) * 100.0;
        return div >= (double)notifyItem.getThreshold();
    }

    private static boolean checkWithAlarmInfo(ExecutorWrapper executorWrapper, NotifyItem notifyItem) {
        AlarmInfo alarmInfo = AlarmCounter.getAlarmInfo(executorWrapper.getThreadPoolName(), notifyItem.getType());
        return alarmInfo.getCount() >= notifyItem.getThreshold();
    }

    private static void preAlarm(Runnable runnable) {
        if (runnable instanceof DtpRunnable) {
            MDC.put((String)"traceId", (String)((DtpRunnable)runnable).getTraceId());
        }
    }

    private static void postAlarm(Runnable runnable) {
        if (runnable instanceof DtpRunnable) {
            MDC.remove((String)"traceId");
        }
    }
}

