/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.notifier.manager;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.common.em.QueueTypeEnum;
import org.dromara.dynamictp.common.em.RejectedTypeEnum;
import org.dromara.dynamictp.common.entity.NotifyItem;
import org.dromara.dynamictp.common.entity.TpMainFields;
import org.dromara.dynamictp.common.pattern.filter.InvokerChain;
import org.dromara.dynamictp.core.notifier.context.BaseNotifyCtx;
import org.dromara.dynamictp.core.notifier.context.NoticeCtx;
import org.dromara.dynamictp.core.notifier.manager.NotifyFilterBuilder;
import org.dromara.dynamictp.core.notifier.manager.NotifyHelper;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;

public class NoticeManager {
    private static final ExecutorService NOTICE_EXECUTOR = ThreadPoolBuilder.newBuilder().threadFactory("dtp-notify").corePoolSize(1).maximumPoolSize(1).workQueue(QueueTypeEnum.LINKED_BLOCKING_QUEUE.getName(), 100).rejectedExecutionHandler(RejectedTypeEnum.DISCARD_OLDEST_POLICY.getName()).buildCommon();
    private static final InvokerChain<BaseNotifyCtx> NOTICE_INVOKER_CHAIN = NotifyFilterBuilder.getCommonInvokerChain();

    private NoticeManager() {
    }

    public static void tryNoticeAsync(ExecutorWrapper executor, TpMainFields oldFields, List<String> diffKeys) {
        NOTICE_EXECUTOR.execute(() -> NoticeManager.doTryNotice(executor, oldFields, diffKeys));
    }

    public static void doTryNotice(ExecutorWrapper executor, TpMainFields oldFields, List<String> diffKeys) {
        NotifyHelper.getNotifyItem(executor, NotifyItemEnum.CHANGE).ifPresent(notifyItem -> {
            NoticeCtx noticeCtx = new NoticeCtx(executor, (NotifyItem)notifyItem, oldFields, diffKeys);
            NOTICE_INVOKER_CHAIN.proceed((Object)noticeCtx);
        });
    }

    public static void destroy() {
        NOTICE_EXECUTOR.shutdownNow();
    }
}

