/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.notifier.manager;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.dynamictp.common.em.NotifyTypeEnum;
import org.dromara.dynamictp.common.pattern.filter.Filter;
import org.dromara.dynamictp.common.pattern.filter.Invoker;
import org.dromara.dynamictp.common.pattern.filter.InvokerChain;
import org.dromara.dynamictp.common.pattern.filter.InvokerChainFactory;
import org.dromara.dynamictp.common.spring.ApplicationContextHolder;
import org.dromara.dynamictp.core.notifier.chain.filter.AlarmBaseFilter;
import org.dromara.dynamictp.core.notifier.chain.filter.NoticeBaseFilter;
import org.dromara.dynamictp.core.notifier.chain.filter.NotifyFilter;
import org.dromara.dynamictp.core.notifier.chain.invoker.AlarmInvoker;
import org.dromara.dynamictp.core.notifier.chain.invoker.NoticeInvoker;
import org.dromara.dynamictp.core.notifier.context.BaseNotifyCtx;

public class NotifyFilterBuilder {
    private NotifyFilterBuilder() {
    }

    public static InvokerChain<BaseNotifyCtx> getAlarmInvokerChain() {
        Map filters = ApplicationContextHolder.getBeansOfType(NotifyFilter.class);
        Collection alarmFilters = Lists.newArrayList(filters.values());
        alarmFilters.add(new AlarmBaseFilter());
        alarmFilters = alarmFilters.stream().filter(x -> x.supports(NotifyTypeEnum.ALARM)).sorted(Comparator.comparing(Filter::getOrder)).collect(Collectors.toList());
        return InvokerChainFactory.buildInvokerChain((Invoker)new AlarmInvoker(), (Filter[])alarmFilters.toArray(new NotifyFilter[0]));
    }

    public static InvokerChain<BaseNotifyCtx> getCommonInvokerChain() {
        Map filters = ApplicationContextHolder.getBeansOfType(NotifyFilter.class);
        Collection noticeFilters = Lists.newArrayList(filters.values());
        noticeFilters.add(new NoticeBaseFilter());
        noticeFilters = noticeFilters.stream().filter(x -> x.supports(NotifyTypeEnum.COMMON)).sorted(Comparator.comparing(Filter::getOrder)).collect(Collectors.toList());
        return InvokerChainFactory.buildInvokerChain((Invoker)new NoticeInvoker(), (Filter[])noticeFilters.toArray(new NotifyFilter[0]));
    }
}

