/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.notifier.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.common.entity.DtpExecutorProps;
import org.dromara.dynamictp.common.entity.NotifyItem;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.entity.TpExecutorProps;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.spring.ApplicationContextHolder;
import org.dromara.dynamictp.common.util.StreamUtil;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.notifier.manager.AlarmManager;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyHelper {
    private static final Logger log = LoggerFactory.getLogger(NotifyHelper.class);
    private static final List<String> COMMON_ALARM_KEYS = Lists.newArrayList((Object[])new String[]{"alarmType", "alarmValue"});
    private static final Set<String> LIVENESS_ALARM_KEYS = Sets.newHashSet((Object[])new String[]{"corePoolSize", "maximumPoolSize", "poolSize", "activeCount"});
    private static final Set<String> CAPACITY_ALARM_KEYS = Sets.newHashSet((Object[])new String[]{"queueType", "queueCapacity", "queueSize", "queueRemaining"});
    private static final Set<String> REJECT_ALARM_KEYS = Sets.newHashSet((Object[])new String[]{"rejectType", "rejectCount"});
    private static final Set<String> RUN_TIMEOUT_ALARM_KEYS = Sets.newHashSet((Object[])new String[]{"runTimeoutCount"});
    private static final Set<String> QUEUE_TIMEOUT_ALARM_KEYS = Sets.newHashSet((Object[])new String[]{"queueTimeoutCount"});
    private static final Set<String> ALL_ALARM_KEYS;
    private static final Map<String, Set<String>> ALARM_KEYS;

    private NotifyHelper() {
    }

    public static Set<String> getAllAlarmKeys() {
        return ALL_ALARM_KEYS;
    }

    public static Set<String> getAlarmKeys(NotifyItemEnum notifyItemEnum) {
        Set<String> keys = ALARM_KEYS.get(notifyItemEnum.name());
        keys.addAll(COMMON_ALARM_KEYS);
        return keys;
    }

    public static Optional<NotifyItem> getNotifyItem(ExecutorWrapper executor, NotifyItemEnum notifyType) {
        if (CollectionUtils.isEmpty(executor.getNotifyItems())) {
            return Optional.empty();
        }
        return executor.getNotifyItems().stream().filter(x -> notifyType.getValue().equalsIgnoreCase(x.getType())).findFirst();
    }

    public static void fillPlatforms(List<String> platformIds, List<NotifyPlatform> platforms, List<NotifyItem> notifyItems) {
        if (CollectionUtils.isEmpty(platforms) || CollectionUtils.isEmpty(notifyItems)) {
            return;
        }
        List globalPlatformIds = StreamUtil.fetchProperty(platforms, NotifyPlatform::getPlatformId);
        notifyItems.forEach(n -> {
            if (CollectionUtils.isNotEmpty((Collection)n.getPlatformIds())) {
                n.setPlatformIds((List)CollectionUtils.intersection((Iterable)globalPlatformIds, (Iterable)n.getPlatformIds()));
            } else if (CollectionUtils.isNotEmpty((Collection)platformIds)) {
                n.setPlatformIds((List)CollectionUtils.intersection((Iterable)globalPlatformIds, (Iterable)platformIds));
            } else {
                n.setPlatformIds(globalPlatformIds);
            }
        });
    }

    public static Optional<NotifyPlatform> getPlatform(String platformId) {
        Map<String, NotifyPlatform> platformMap = NotifyHelper.getAllPlatforms();
        return Optional.ofNullable(platformMap.get(platformId));
    }

    public static Map<String, NotifyPlatform> getAllPlatforms() {
        DtpProperties dtpProperties = (DtpProperties)ApplicationContextHolder.getBean(DtpProperties.class);
        if (CollectionUtils.isEmpty((Collection)dtpProperties.getPlatforms())) {
            return Collections.emptyMap();
        }
        return StreamUtil.toMap((Collection)dtpProperties.getPlatforms(), NotifyPlatform::getPlatformId);
    }

    public static void initNotify(DtpExecutor executor) {
        DtpProperties dtpProperties = (DtpProperties)ApplicationContextHolder.getBean(DtpProperties.class);
        List platforms = dtpProperties.getPlatforms();
        if (CollectionUtils.isEmpty((Collection)platforms)) {
            executor.setNotifyItems(Lists.newArrayList());
            executor.setPlatformIds(Lists.newArrayList());
            log.warn("DynamicTp notify, no notify platforms configured for [{}]", (Object)executor.getThreadPoolName());
            return;
        }
        if (CollectionUtils.isEmpty(executor.getNotifyItems())) {
            log.warn("DynamicTp notify, no notify items configured for [{}]", (Object)executor.getThreadPoolName());
            return;
        }
        NotifyHelper.fillPlatforms(executor.getPlatformIds(), platforms, executor.getNotifyItems());
        AlarmManager.initAlarm(executor.getThreadPoolName(), executor.getNotifyItems());
    }

    public static void updateNotifyInfo(ExecutorWrapper executorWrapper, TpExecutorProps props, List<NotifyPlatform> platforms) {
        List allNotifyItems = NotifyItem.mergeAllNotifyItems((List)props.getNotifyItems());
        NotifyHelper.refreshNotify(executorWrapper.getThreadPoolName(), props.getPlatformIds(), platforms, executorWrapper.getNotifyItems(), allNotifyItems);
        executorWrapper.setNotifyItems(allNotifyItems);
        executorWrapper.setPlatformIds(props.getPlatformIds());
        executorWrapper.setNotifyEnabled(props.isNotifyEnabled());
    }

    public static void updateNotifyInfo(DtpExecutor executor, DtpExecutorProps props, List<NotifyPlatform> platforms) {
        List allNotifyItems = NotifyItem.mergeAllNotifyItems((List)props.getNotifyItems());
        NotifyHelper.refreshNotify(executor.getThreadPoolName(), props.getPlatformIds(), platforms, executor.getNotifyItems(), allNotifyItems);
        executor.setNotifyItems(allNotifyItems);
        executor.setPlatformIds(props.getPlatformIds());
        executor.setNotifyEnabled(props.isNotifyEnabled());
    }

    private static void refreshNotify(String poolName, List<String> platformIds, List<NotifyPlatform> platforms, List<NotifyItem> oldNotifyItems, List<NotifyItem> newNotifyItems) {
        NotifyHelper.fillPlatforms(platformIds, platforms, newNotifyItems);
        Map oldNotifyItemMap = StreamUtil.toMap(oldNotifyItems, NotifyItem::getType);
        newNotifyItems.forEach(x -> {
            NotifyItem oldNotifyItem = (NotifyItem)oldNotifyItemMap.get(x.getType());
            if (Objects.nonNull(oldNotifyItem) && oldNotifyItem.getInterval() == x.getInterval()) {
                return;
            }
            AlarmManager.initAlarm(poolName, x);
        });
    }

    static {
        ALARM_KEYS = Maps.newHashMap();
        ALARM_KEYS.put(NotifyItemEnum.LIVENESS.name(), LIVENESS_ALARM_KEYS);
        ALARM_KEYS.put(NotifyItemEnum.CAPACITY.name(), CAPACITY_ALARM_KEYS);
        ALARM_KEYS.put(NotifyItemEnum.REJECT.name(), REJECT_ALARM_KEYS);
        ALARM_KEYS.put(NotifyItemEnum.RUN_TIMEOUT.name(), RUN_TIMEOUT_ALARM_KEYS);
        ALARM_KEYS.put(NotifyItemEnum.QUEUE_TIMEOUT.name(), QUEUE_TIMEOUT_ALARM_KEYS);
        ALL_ALARM_KEYS = ALARM_KEYS.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        ALL_ALARM_KEYS.addAll(COMMON_ALARM_KEYS);
    }
}

