/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.refresher;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.em.ConfigFileTypeEnum;
import org.dromara.dynamictp.common.event.RefreshEvent;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.spring.ApplicationContextHolder;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.handler.ConfigHandler;
import org.dromara.dynamictp.core.refresher.Refresher;
import org.dromara.dynamictp.core.support.BinderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public abstract class AbstractRefresher
implements Refresher,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractRefresher.class);
    protected final DtpProperties dtpProperties;
    protected Environment environment;

    protected AbstractRefresher(DtpProperties dtpProperties) {
        this.dtpProperties = dtpProperties;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void refresh(String content, ConfigFileTypeEnum fileType) {
        if (StringUtils.isBlank((CharSequence)content) || Objects.isNull(fileType)) {
            log.warn("DynamicTp refresh, empty content or null fileType.");
            return;
        }
        try {
            ConfigHandler configHandler = ConfigHandler.getInstance();
            Map<Object, Object> properties = configHandler.parseConfig(content, fileType);
            this.refresh(properties);
        }
        catch (IOException e) {
            log.error("DynamicTp refresh error, content: {}, fileType: {}", new Object[]{content, fileType, e});
        }
    }

    protected void refresh(Map<Object, Object> properties) {
        if (MapUtils.isEmpty(properties)) {
            log.warn("DynamicTp refresh, empty properties.");
            return;
        }
        BinderHelper.bindDtpProperties(properties, this.dtpProperties);
        this.doRefresh(this.dtpProperties);
    }

    protected void refresh(Environment environment) {
        BinderHelper.bindDtpProperties(environment, this.dtpProperties);
        this.doRefresh(this.dtpProperties);
    }

    protected void doRefresh(DtpProperties properties) {
        DtpRegistry.refresh(properties);
        this.publishEvent(properties);
    }

    protected boolean needRefresh(Set<String> changedKeys) {
        if (CollectionUtils.isEmpty(changedKeys)) {
            return false;
        }
        changedKeys = changedKeys.stream().filter(str -> str.startsWith("spring.dynamic.tp")).collect(Collectors.toSet());
        return CollectionUtils.isNotEmpty(changedKeys);
    }

    private void publishEvent(DtpProperties dtpProperties) {
        RefreshEvent event = new RefreshEvent((Object)this, dtpProperties);
        ApplicationContextHolder.publishEvent((ApplicationEvent)event);
    }
}

