/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.reject;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.dromara.dynamictp.core.aware.AwareManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectedInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RejectedInvocationHandler.class);
    private final Object target;

    public RejectedInvocationHandler(Object target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.beforeReject((Runnable)args[0], (Executor)args[1]);
        try {
            Object object = method.invoke(this.target, args);
            return object;
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
        finally {
            this.afterReject((Runnable)args[0], (Executor)args[1]);
        }
    }

    private void beforeReject(Runnable runnable, Executor executor) {
        AwareManager.beforeReject(runnable, executor);
    }

    private void afterReject(Runnable runnable, Executor executor) {
        AwareManager.afterReject(runnable, executor);
    }
}

