/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.spring;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.common.spring.ApplicationContextHolder;
import org.dromara.dynamictp.common.spring.SpringBeanHelper;
import org.dromara.dynamictp.common.timer.HashedWheelTimer;
import org.dromara.dynamictp.core.executor.NamedThreadFactory;
import org.dromara.dynamictp.core.spring.DtpPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public class DtpBaseBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String APPLICATION_CONTEXT_HOLDER = "dtpApplicationContextHolder";
    private static final String HASHED_WHEEL_TIMER = "dtpHashedWheelTimer";
    private static final String DTP_POST_PROCESSOR = "dtpPostProcessor";

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.registerHashedWheelTimer(registry);
        SpringBeanHelper.registerIfAbsent((BeanDefinitionRegistry)registry, (String)APPLICATION_CONTEXT_HOLDER, ApplicationContextHolder.class, (Object[])new Object[0]);
        SpringBeanHelper.registerIfAbsent((BeanDefinitionRegistry)registry, (String)DTP_POST_PROCESSOR, DtpPostProcessor.class, null, (List)Lists.newArrayList((Object[])new String[]{APPLICATION_CONTEXT_HOLDER, HASHED_WHEEL_TIMER}), (Object[])new Object[0]);
    }

    private void registerHashedWheelTimer(BeanDefinitionRegistry registry) {
        Object[] constructorArgs = new Object[]{new NamedThreadFactory("dtp-runnable-timeout", true), 10, TimeUnit.MILLISECONDS};
        SpringBeanHelper.registerIfAbsent((BeanDefinitionRegistry)registry, (String)HASHED_WHEEL_TIMER, HashedWheelTimer.class, (Object[])constructorArgs);
    }
}

