/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.spring;

import java.util.concurrent.atomic.AtomicBoolean;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.monitor.DtpMonitor;
import org.dromara.dynamictp.core.notifier.manager.AlarmManager;
import org.dromara.dynamictp.core.notifier.manager.NoticeManager;
import org.dromara.dynamictp.core.support.DtpLifecycleSupport;
import org.dromara.dynamictp.core.system.SystemMetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;

public class DtpLifecycle
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DtpLifecycle.class);
    private final AtomicBoolean running = new AtomicBoolean(false);

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            DtpRegistry.getAllExecutors().forEach((k, v) -> DtpLifecycleSupport.initialize(v));
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.shutdownInternal();
            DtpRegistry.getAllExecutors().forEach((k, v) -> DtpLifecycleSupport.destroy(v));
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isAutoStartup() {
        return true;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void shutdownInternal() {
        DtpMonitor.destroy();
        AlarmManager.destroy();
        NoticeManager.destroy();
        SystemMetricManager.stop();
    }
}

