/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.support;

import java.util.Map;
import java.util.Objects;
import org.dromara.dynamictp.common.pattern.singleton.Singleton;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.util.ExtensionServiceLoader;
import org.dromara.dynamictp.core.spring.PropertiesBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class BinderHelper {
    private static final Logger log = LoggerFactory.getLogger(BinderHelper.class);

    private BinderHelper() {
    }

    private static PropertiesBinder getBinder() {
        PropertiesBinder binder = (PropertiesBinder)Singleton.INST.get(PropertiesBinder.class);
        if (Objects.nonNull(binder)) {
            return binder;
        }
        PropertiesBinder loadedFirstBinder = (PropertiesBinder)ExtensionServiceLoader.getFirst(PropertiesBinder.class);
        if (Objects.isNull(loadedFirstBinder)) {
            log.error("DynamicTp refresh, no SPI for org.dromara.dynamictp.core.spring.PropertiesBinder.");
            return null;
        }
        Singleton.INST.single(PropertiesBinder.class, (Object)loadedFirstBinder);
        return loadedFirstBinder;
    }

    public static void bindDtpProperties(Map<?, Object> properties, DtpProperties dtpProperties) {
        PropertiesBinder binder = BinderHelper.getBinder();
        if (Objects.isNull(binder)) {
            return;
        }
        binder.bindDtpProperties(properties, dtpProperties);
    }

    public static void bindDtpProperties(Environment environment, DtpProperties dtpProperties) {
        PropertiesBinder binder = BinderHelper.getBinder();
        if (Objects.isNull(binder)) {
            return;
        }
        binder.bindDtpProperties(environment, dtpProperties);
    }
}

