/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.support;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolExecutorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtpLifecycleSupport {
    private static final Logger log = LoggerFactory.getLogger(DtpLifecycleSupport.class);

    private DtpLifecycleSupport() {
    }

    public static void initialize(ExecutorWrapper executorWrapper) {
        executorWrapper.initialize();
    }

    public static void destroy(ExecutorWrapper executorWrapper) {
        if (executorWrapper.isDtpExecutor()) {
            DtpLifecycleSupport.destroy((DtpExecutor)executorWrapper.getExecutor());
        } else if (executorWrapper.isThreadPoolExecutor()) {
            DtpLifecycleSupport.internalShutdown(((ThreadPoolExecutorAdapter)executorWrapper.getExecutor()).getOriginal(), executorWrapper.getThreadPoolName(), true, 0);
        }
    }

    public static void destroy(DtpExecutor executor) {
        DtpLifecycleSupport.internalShutdown(executor, executor.getThreadPoolName(), executor.isWaitForTasksToCompleteOnShutdown(), executor.getAwaitTerminationSeconds());
    }

    public static void shutdownGracefulAsync(ExecutorService executor, String threadPoolName, int timeout) {
        ExecutorService tmpExecutor = Executors.newSingleThreadExecutor();
        tmpExecutor.execute(() -> DtpLifecycleSupport.internalShutdown(executor, threadPoolName, true, timeout));
        tmpExecutor.shutdown();
    }

    public static void internalShutdown(ExecutorService executor, String threadPoolName, boolean waitForTasksToCompleteOnShutdown, int awaitTerminationSeconds) {
        if (Objects.isNull(executor)) {
            return;
        }
        log.info("Shutting down ExecutorService, threadPoolName: {}", (Object)threadPoolName);
        if (waitForTasksToCompleteOnShutdown) {
            executor.shutdown();
        } else {
            for (Runnable remainingTask : executor.shutdownNow()) {
                DtpLifecycleSupport.cancelRemainingTask(remainingTask);
            }
        }
        DtpLifecycleSupport.awaitTerminationIfNecessary(executor, threadPoolName, awaitTerminationSeconds);
    }

    protected static void cancelRemainingTask(Runnable task) {
        if (task instanceof Future) {
            ((Future)((Object)task)).cancel(true);
        }
    }

    private static void awaitTerminationIfNecessary(ExecutorService executor, String threadPoolName, int awaitTerminationSeconds) {
        if (awaitTerminationSeconds <= 0) {
            return;
        }
        try {
            if (!executor.awaitTermination(awaitTerminationSeconds, TimeUnit.SECONDS)) {
                log.warn("Timed out while waiting for executor {} to terminate", (Object)threadPoolName);
            }
        }
        catch (InterruptedException ex) {
            log.warn("Interrupted while waiting for executor {} to terminate", (Object)threadPoolName);
            Thread.currentThread().interrupt();
        }
    }
}

