/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.core.support;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;

public interface ExecutorAdapter<E extends Executor>
extends Executor {
    public E getOriginal();

    @Override
    default public void execute(Runnable command) {
        this.getOriginal().execute(command);
    }

    public int getCorePoolSize();

    public void setCorePoolSize(int var1);

    public int getMaximumPoolSize();

    public void setMaximumPoolSize(int var1);

    public int getPoolSize();

    public int getActiveCount();

    default public int getLargestPoolSize() {
        return -1;
    }

    default public long getTaskCount() {
        return -1L;
    }

    default public long getCompletedTaskCount() {
        return -1L;
    }

    default public BlockingQueue<Runnable> getQueue() {
        return new UnsupportedBlockingQueue();
    }

    default public String getQueueType() {
        return this.getQueue().getClass().getSimpleName();
    }

    default public int getQueueSize() {
        return this.getQueue().size();
    }

    default public int getQueueRemainingCapacity() {
        return this.getQueue().remainingCapacity();
    }

    default public int getQueueCapacity() {
        int capacity = this.getQueueSize() + this.getQueueRemainingCapacity();
        return capacity < 0 ? Integer.MAX_VALUE : capacity;
    }

    default public void onRefreshQueueCapacity(int capacity) {
    }

    default public RejectedExecutionHandler getRejectedExecutionHandler() {
        return null;
    }

    default public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
    }

    default public String getRejectHandlerType() {
        return Optional.ofNullable(this.getRejectedExecutionHandler()).map(h -> h.getClass().getSimpleName()).orElse("unknown");
    }

    default public boolean allowsCoreThreadTimeOut() {
        return false;
    }

    default public void allowCoreThreadTimeOut(boolean value) {
    }

    default public long getKeepAliveTime(TimeUnit unit) {
        return -1L;
    }

    default public void setKeepAliveTime(long time, TimeUnit unit) {
    }

    default public boolean isShutdown() {
        return false;
    }

    default public boolean isTerminated() {
        return false;
    }

    default public boolean isTerminating() {
        return false;
    }

    public static class UnsupportedBlockingQueue
    extends AbstractQueue<Runnable>
    implements BlockingQueue<Runnable> {
        @Override
        public Iterator<Runnable> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void put(Runnable runnable) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(Runnable runnable, long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Runnable take() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remainingCapacity() {
            return 0;
        }

        @Override
        public int drainTo(Collection<? super Runnable> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(Runnable runnable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Runnable poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Runnable peek() {
            throw new UnsupportedOperationException();
        }
    }
}

